/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpContext;
import org.jobrunr.dashboard.JobRunrApiHandler;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.dashboard.JobRunrSseHandler;
import org.jobrunr.dashboard.JobRunrStaticFileHandler;
import org.jobrunr.dashboard.server.HttpExchangeHandler;
import org.jobrunr.dashboard.server.WebServer;
import org.jobrunr.dashboard.server.http.RedirectHttpHandler;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.ThreadSafeStorageProvider;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.annotations.VisibleFor;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunrDashboardWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunrDashboardWebServer.class);
    private final StorageProvider storageProvider;
    private final JsonMapper jsonMapper;
    private final int port;
    private final BasicAuthenticator basicAuthenticator;
    private final boolean allowAnonymousDataUsage;
    private WebServer webServer;

    public static void main(String[] args) {
        new JobRunrDashboardWebServer(null, new JacksonJsonMapper());
    }

    public JobRunrDashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper) {
        this(storageProvider, jsonMapper, 8000);
    }

    public JobRunrDashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper, int port) {
        this(storageProvider, jsonMapper, JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(port));
    }

    public JobRunrDashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper, int port, String username, String password) {
        this(storageProvider, jsonMapper, JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(port).andBasicAuthentication(username, password));
    }

    public JobRunrDashboardWebServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobRunrDashboardWebServerConfiguration configuration) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A StorageProvider is required to use a JobRunrDashboardWebServer. Please see the documentation on how to setup a job StorageProvider.");
        }
        this.storageProvider = new ThreadSafeStorageProvider(storageProvider);
        this.jsonMapper = jsonMapper;
        this.allowAnonymousDataUsage = configuration.allowAnonymousDataUsage;
        this.port = configuration.port;
        this.basicAuthenticator = this.createOptionalBasicAuthenticator(configuration.username, configuration.password);
    }

    public void start() {
        RedirectHttpHandler redirectHttpHandler = new RedirectHttpHandler("/", "/dashboard");
        JobRunrStaticFileHandler staticFileHandler = this.createStaticFileHandler();
        JobRunrApiHandler dashboardHandler = this.createApiHandler(this.storageProvider, this.jsonMapper, this.allowAnonymousDataUsage);
        JobRunrSseHandler sseHandler = this.createSSeHandler(this.storageProvider, this.jsonMapper);
        this.webServer = new WebServer(this.port);
        this.registerContext(redirectHttpHandler);
        this.registerSecuredContext(staticFileHandler);
        this.registerSecuredContext(dashboardHandler);
        this.registerSecuredContext(sseHandler);
        this.webServer.start();
        LOGGER.info("JobRunr Dashboard using {} started at http://{}:{}/dashboard", new Object[]{this.storageProvider.getStorageProviderInfo().getName(), this.webServer.getWebServerHostAddress(), this.webServer.getWebServerHostPort()});
    }

    public void stop() {
        if (this.webServer == null) {
            return;
        }
        this.webServer.stop();
        LOGGER.info("JobRunr dashboard stopped");
        this.webServer = null;
    }

    HttpContext registerContext(HttpExchangeHandler httpHandler) {
        return this.webServer.createContext(httpHandler);
    }

    HttpContext registerSecuredContext(HttpExchangeHandler httpHandler) {
        HttpContext httpContext = this.registerContext(httpHandler);
        if (this.basicAuthenticator != null) {
            httpContext.setAuthenticator(this.basicAuthenticator);
        }
        return httpContext;
    }

    @VisibleFor(value="github issue 18")
    JobRunrStaticFileHandler createStaticFileHandler() {
        return new JobRunrStaticFileHandler();
    }

    @VisibleFor(value="github issue 18")
    JobRunrApiHandler createApiHandler(StorageProvider storageProvider, JsonMapper jsonMapper, boolean allowAnonymousDataUsage) {
        return new JobRunrApiHandler(storageProvider, jsonMapper, allowAnonymousDataUsage);
    }

    @VisibleFor(value="github issue 18")
    JobRunrSseHandler createSSeHandler(StorageProvider storageProvider, JsonMapper jsonMapper) {
        return new JobRunrSseHandler(storageProvider, jsonMapper);
    }

    private BasicAuthenticator createOptionalBasicAuthenticator(final String username, final String password) {
        if (StringUtils.isNotNullOrEmpty(username) && StringUtils.isNotNullOrEmpty(password)) {
            return new BasicAuthenticator("JobRunr"){

                @Override
                public boolean checkCredentials(String user, String pwd) {
                    return user.equals(username) && pwd.equals(password);
                }
            };
        }
        return null;
    }
}

