/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.sse;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import org.jobrunr.dashboard.sse.AbstractObjectSseExchange;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.JobChangeListener;
import org.jobrunr.utils.mapper.JsonMapper;

public class JobSseExchange
extends AbstractObjectSseExchange
implements JobChangeListener {
    private final StorageProvider storageProvider;
    private final JobId jobId;

    public JobSseExchange(HttpExchange httpExchange, StorageProvider storageProvider, JsonMapper jsonMapper) throws IOException {
        super(httpExchange, jsonMapper);
        this.storageProvider = storageProvider;
        this.jobId = JobSseExchange.getJobId(httpExchange);
        storageProvider.addJobStorageOnChangeListener(this);
    }

    @Override
    public JobId getJobId() {
        return this.jobId;
    }

    @Override
    public void onChange(Job job) {
        this.sendObject(job);
        if (job.hasState(StateName.SUCCEEDED) || job.hasState(StateName.FAILED) || job.hasState(StateName.DELETED)) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.storageProvider.removeJobStorageOnChangeListener(this);
        super.close();
    }

    private static JobId getJobId(HttpExchange httpExchange) {
        String url = httpExchange.getRequestURI().toString();
        return JobId.parse(url.substring("/sse/jobs/".length()));
    }
}

