/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.ui.model.problems;

import java.util.List;
import org.jobrunr.dashboard.ui.model.problems.CpuAllocationIrregularityProblem;
import org.jobrunr.dashboard.ui.model.problems.ProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.Problems;
import org.jobrunr.server.dashboard.CpuAllocationIrregularityNotification;
import org.jobrunr.server.dashboard.PollIntervalInSecondsTimeBoxIsTooSmallNotification;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.MetadataChangeListener;

public class CpuAllocationIrregularityProblemHandler
implements MetadataChangeListener,
ProblemHandler {
    private final Problems problems;
    private final StorageProvider storageProvider;
    private List<JobRunrMetadata> serversWithLongGCCyclesMetadataList;

    public CpuAllocationIrregularityProblemHandler(Problems problems, StorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addJobStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(CpuAllocationIrregularityNotification.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        this.problems.removeProblemsOfType("cpu-allocation-irregularity");
        this.storageProvider.deleteMetadata(CpuAllocationIrregularityNotification.class.getSimpleName());
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return CpuAllocationIrregularityNotification.class.getSimpleName();
    }

    @Override
    public void onChange(List<JobRunrMetadata> metadataList) {
        if (this.serversWithLongGCCyclesMetadataList == null || this.serversWithLongGCCyclesMetadataList.size() != metadataList.size()) {
            this.problems.removeProblemsOfType("cpu-allocation-irregularity");
            if (!metadataList.isEmpty()) {
                this.problems.addProblem(new CpuAllocationIrregularityProblem(metadataList));
                this.problems.removeProblemsOfType("poll-interval-in-seconds-is-too-small");
                this.storageProvider.deleteMetadata(PollIntervalInSecondsTimeBoxIsTooSmallNotification.class.getSimpleName());
            }
            this.serversWithLongGCCyclesMetadataList = metadataList;
        }
    }
}

