/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.ui.model.problems;

import java.util.Set;
import java.util.stream.Collectors;
import org.jobrunr.dashboard.ui.model.problems.ProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.Problems;
import org.jobrunr.dashboard.ui.model.problems.ScheduledJobsNotFoundProblem;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.JobStatsChangeListener;
import org.jobrunr.utils.JobUtils;

public class ScheduledJobsNotFoundProblemHandler
implements JobStatsChangeListener,
ProblemHandler {
    private final Problems problems;
    private final StorageProvider storageProvider;
    private JobStats jobStats;

    public ScheduledJobsNotFoundProblemHandler(Problems problems, StorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.initScheduledJobNotFoundProblems();
    }

    @Override
    public void dismiss() {
        throw new IllegalStateException("Problem of type 'jobs-not-found' cannot be dismissed.");
    }

    @Override
    public void onChange(JobStats jobStats) {
        if (this.jobStats == null || jobStats.getScheduled() < this.jobStats.getScheduled()) {
            this.initScheduledJobNotFoundProblems();
            this.jobStats = jobStats;
        }
    }

    private void initScheduledJobNotFoundProblems() {
        this.problems.removeProblemsOfType("jobs-not-found");
        Set<String> jobsThatCannotBeFoundAnymore = this.storageProvider.getDistinctJobSignatures(StateName.SCHEDULED).stream().filter(jobSignature -> !JobUtils.jobExists(jobSignature)).collect(Collectors.toSet());
        if (!jobsThatCannotBeFoundAnymore.isEmpty()) {
            this.storageProvider.addJobStorageOnChangeListener(this);
            this.jobStats = this.storageProvider.getJobStats();
            this.problems.addProblem(new ScheduledJobsNotFoundProblem(jobsThatCannotBeFoundAnymore));
        } else {
            this.storageProvider.removeJobStorageOnChangeListener(this);
        }
    }
}

