/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.ui.model.problems;

import java.util.List;
import org.jobrunr.SevereJobRunrException;
import org.jobrunr.dashboard.ui.model.problems.ProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.Problems;
import org.jobrunr.dashboard.ui.model.problems.SevereJobRunrExceptionProblem;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.MetadataChangeListener;

public class SevereJobRunrExceptionProblemHandler
implements MetadataChangeListener,
ProblemHandler {
    private final Problems problems;
    private final StorageProvider storageProvider;
    private List<JobRunrMetadata> severeJobRunrExceptionAsMetadataList;

    public SevereJobRunrExceptionProblemHandler(Problems problems, StorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addJobStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(SevereJobRunrException.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        this.problems.removeProblemsOfType("severe-jobrunr-exception");
        this.storageProvider.deleteMetadata(SevereJobRunrException.class.getSimpleName());
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return SevereJobRunrException.class.getSimpleName();
    }

    @Override
    public void onChange(List<JobRunrMetadata> metadataList) {
        if (this.severeJobRunrExceptionAsMetadataList == null || this.severeJobRunrExceptionAsMetadataList.size() != metadataList.size()) {
            this.problems.removeProblemsOfType("severe-jobrunr-exception");
            if (!metadataList.isEmpty()) {
                this.problems.addProblem(new SevereJobRunrExceptionProblem(metadataList));
            }
            this.severeJobRunrExceptionAsMetadataList = metadataList;
        }
    }
}

