/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.resilience.Lock;
import org.jobrunr.utils.resilience.Lockable;

public abstract class AbstractJob
implements Lockable {
    private static final int MAX_AMOUNT_OF_LABELS = 3;
    private static final int MAX_LABEL_LENGTH = 45;
    private final transient Lock locker = new Lock();
    private volatile int version;
    private String jobSignature;
    private String jobName;
    private Integer amountOfRetries;
    private HashSet<String> labels = new HashSet();
    private JobDetails jobDetails;

    protected AbstractJob() {
    }

    protected AbstractJob(JobDetails jobDetails) {
        this(jobDetails, 0);
    }

    protected AbstractJob(JobDetails jobDetails, int version) {
        this();
        this.jobDetails = jobDetails;
        this.version = version;
        this.jobSignature = JobUtils.getJobSignature(jobDetails);
    }

    public abstract Object getId();

    public int getVersion() {
        return this.version;
    }

    synchronized int increaseVersion() {
        return ++this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public String getJobSignature() {
        return this.jobSignature;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Integer getAmountOfRetries() {
        return this.amountOfRetries;
    }

    public void setAmountOfRetries(Integer retries) {
        this.amountOfRetries = retries;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public void setLabels(Set<String> labels) {
        if (CollectionUtils.isNotNullOrEmpty(labels)) {
            if (labels.size() > 3) {
                throw new IllegalArgumentException(String.format("Per job a maximum of %d labels can be provided.", 3));
            }
            if (labels.stream().anyMatch(label -> label.length() > 45)) {
                throw new IllegalArgumentException(String.format("Label length must be less than %d characters.", 45));
            }
            this.labels = new HashSet<String>(labels);
        }
    }

    public JobDetails getJobDetails() {
        return this.jobDetails;
    }

    @Override
    public Lock lock() {
        return this.locker.lock();
    }
}

