/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.states.AllowedJobStateStateChanges;
import org.jobrunr.jobs.states.DeletedState;
import org.jobrunr.jobs.states.EnqueuedState;
import org.jobrunr.jobs.states.FailedState;
import org.jobrunr.jobs.states.IllegalJobStateChangeException;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.jobs.states.ProcessingState;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.jobs.states.SucceededState;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.streams.StreamUtils;

public class Job
extends AbstractJob {
    private static final Pattern METADATA_PATTERN = Pattern.compile("(\\bjobRunrDashboardLog\\b|\\bjobRunrDashboardProgressBar\\b)-(\\d+)");
    private final UUID id;
    private final CopyOnWriteArrayList<JobState> jobHistory;
    private final ConcurrentMap<String, Object> metadata;
    private String recurringJobId;

    private Job() {
        this.id = null;
        this.jobHistory = new CopyOnWriteArrayList();
        this.metadata = new ConcurrentHashMap<String, Object>();
    }

    public Job(JobDetails jobDetails) {
        this(jobDetails, new EnqueuedState());
    }

    public Job(UUID id, JobDetails jobDetails) {
        this(id, jobDetails, new EnqueuedState());
    }

    public Job(JobDetails jobDetails, JobState jobState) {
        this(null, 0, jobDetails, Collections.singletonList(jobState), new ConcurrentHashMap<String, Object>());
    }

    public Job(UUID id, JobDetails jobDetails, JobState jobState) {
        this(id, 0, jobDetails, Collections.singletonList(jobState), new ConcurrentHashMap<String, Object>());
    }

    public Job(UUID id, int version, JobDetails jobDetails, List<JobState> jobHistory, ConcurrentMap<String, Object> metadata) {
        super(jobDetails, version);
        if (jobHistory.isEmpty()) {
            throw new IllegalStateException("A job should have at least one initial state");
        }
        this.id = id != null ? id : UUID.randomUUID();
        this.jobHistory = new CopyOnWriteArrayList<JobState>(jobHistory);
        this.metadata = metadata;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public void setRecurringJobId(String recurringJobId) {
        this.recurringJobId = recurringJobId;
    }

    public Optional<String> getRecurringJobId() {
        return Optional.ofNullable(this.recurringJobId);
    }

    public List<JobState> getJobStates() {
        return Collections.unmodifiableList(this.jobHistory);
    }

    public <T extends JobState> Stream<T> getJobStatesOfType(Class<T> clazz) {
        return StreamUtils.ofType(this.getJobStates(), clazz);
    }

    public <T extends JobState> Optional<T> getLastJobStateOfType(Class<T> clazz) {
        return this.getJobStatesOfType(clazz).reduce((first, second) -> second);
    }

    public <T extends JobState> T getJobState() {
        return (T)((JobState)ReflectionUtils.cast(this.getJobState(-1)));
    }

    public JobState getJobState(int element) {
        if (element >= 0) {
            return this.jobHistory.get(element);
        }
        if (Math.abs(element) > this.jobHistory.size()) {
            return null;
        }
        return this.jobHistory.get(this.jobHistory.size() + element);
    }

    public StateName getState() {
        return this.getJobState().getName();
    }

    public boolean hasState(StateName state) {
        return this.getState().equals((Object)state);
    }

    public void enqueue() {
        this.addJobState(new EnqueuedState());
    }

    public void scheduleAt(Instant instant, String reason) {
        this.addJobState(new ScheduledState(instant, reason));
    }

    public void startProcessingOn(BackgroundJobServer backgroundJobServer) {
        if (this.getState() == StateName.PROCESSING) {
            throw new ConcurrentJobModificationException(this);
        }
        this.addJobState(new ProcessingState(backgroundJobServer));
    }

    public void updateProcessing() {
        ProcessingState jobState = (ProcessingState)this.getJobState();
        jobState.setUpdatedAt(Instant.now());
    }

    public void succeeded() {
        Optional<EnqueuedState> lastEnqueuedState = this.getLastJobStateOfType(EnqueuedState.class);
        if (!lastEnqueuedState.isPresent()) {
            throw new IllegalStateException("Job cannot succeed if it was not enqueued before.");
        }
        this.clearMetadata();
        Duration latencyDuration = Duration.between(lastEnqueuedState.get().getEnqueuedAt(), this.getJobState().getCreatedAt());
        Duration processDuration = Duration.between(this.getJobState().getCreatedAt(), Instant.now());
        this.addJobState(new SucceededState(latencyDuration, processDuration));
    }

    public void failed(String message, Exception exception) {
        this.addJobState(new FailedState(message, exception));
    }

    public void delete(String reason) {
        this.clearMetadata();
        this.addJobState(new DeletedState(reason));
    }

    public Instant getCreatedAt() {
        return this.getJobState(0).getCreatedAt();
    }

    public Instant getUpdatedAt() {
        return this.getJobState().getUpdatedAt();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Job{id=" + this.id + ", version='" + this.getVersion() + '\'' + ", identity='" + System.identityHashCode(this) + '\'' + ", jobSignature='" + this.getJobSignature() + '\'' + ", jobName='" + this.getJobName() + '\'' + ", jobState='" + (Object)((Object)this.getState()) + '\'' + ", updatedAt='" + this.getUpdatedAt() + '\'' + '}';
    }

    private void addJobState(JobState jobState) {
        if (AllowedJobStateStateChanges.isIllegalStateChange(this.getState(), jobState.getName())) {
            throw new IllegalJobStateChangeException(this.getState(), jobState.getName());
        }
        this.jobHistory.add(jobState);
    }

    private void clearMetadata() {
        this.metadata.entrySet().removeIf(entry -> !METADATA_PATTERN.matcher((CharSequence)entry.getKey()).matches());
    }
}

