/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobVersioner;

public class JobListVersioner
implements AutoCloseable {
    private final List<JobVersioner> jobVersioners;

    public JobListVersioner(List<Job> jobs) {
        this.jobVersioners = jobs.stream().map(JobVersioner::new).collect(Collectors.toList());
    }

    public boolean areNewJobs() {
        this.validateJobs();
        return this.jobVersioners.get(0).isNewJob();
    }

    public void validateJobs() {
        if (this.jobVersioners.get(0).isNewJob() ? !this.jobVersioners.stream().allMatch(JobVersioner::isNewJob) : this.jobVersioners.stream().anyMatch(JobVersioner::isNewJob)) {
            throw new IllegalArgumentException("All jobs must be either new (with id == null) or existing (with id != null)");
        }
    }

    public void commitVersions() {
        this.jobVersioners.forEach(JobVersioner::commitVersion);
    }

    public void rollbackVersions(List<Job> jobsThatFailed) {
        Set jobIdsThatFailed = jobsThatFailed.stream().map(Job::getId).collect(Collectors.toSet());
        this.jobVersioners.stream().filter(jobVersioner -> !jobIdsThatFailed.contains(jobVersioner.getJob().getId())).forEach(JobVersioner::commitVersion);
    }

    @Override
    public void close() {
        this.jobVersioners.forEach(JobVersioner::close);
    }
}

