/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import org.jobrunr.jobs.Job;

public class JobVersioner
implements AutoCloseable {
    private final Job job;
    private final int initialJobVersion;
    private boolean isVersionCommitted = false;

    public JobVersioner(Job job) {
        this.job = job;
        this.initialJobVersion = job.getVersion();
        this.job.increaseVersion();
    }

    public boolean isNewJob() {
        return this.initialJobVersion == 0;
    }

    public void commitVersion() {
        this.isVersionCommitted = true;
    }

    Job getJob() {
        return this.job;
    }

    @Override
    public void close() {
        if (!this.isVersionCommitted) {
            this.job.setVersion(this.initialJobVersion);
        }
    }
}

