/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details.instructions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.details.JobDetailsBuilder;
import org.jobrunr.jobs.details.instructions.AAStoreInstruction;
import org.jobrunr.jobs.details.instructions.ALoadOperandInstruction;
import org.jobrunr.jobs.details.instructions.ANewArrayOperandInstruction;
import org.jobrunr.jobs.details.instructions.AStoreInstruction;
import org.jobrunr.jobs.details.instructions.AbstractJVMInstruction;
import org.jobrunr.jobs.details.instructions.CheckCastOperandInstruction;
import org.jobrunr.jobs.details.instructions.DLoadOperandInstruction;
import org.jobrunr.jobs.details.instructions.DStoreInstruction;
import org.jobrunr.jobs.details.instructions.DupOperandInstruction;
import org.jobrunr.jobs.details.instructions.FLoadOperandInstruction;
import org.jobrunr.jobs.details.instructions.FStoreInstruction;
import org.jobrunr.jobs.details.instructions.GetFieldInstruction;
import org.jobrunr.jobs.details.instructions.GetStaticInstruction;
import org.jobrunr.jobs.details.instructions.I2BOperandInstruction;
import org.jobrunr.jobs.details.instructions.I2COperandInstruction;
import org.jobrunr.jobs.details.instructions.I2DOperandInstruction;
import org.jobrunr.jobs.details.instructions.I2FOperandInstruction;
import org.jobrunr.jobs.details.instructions.I2LOperandInstruction;
import org.jobrunr.jobs.details.instructions.I2SOperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst0OperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst1OperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst2OperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst3OperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst4OperandInstruction;
import org.jobrunr.jobs.details.instructions.IConst5OperandInstruction;
import org.jobrunr.jobs.details.instructions.ILoadOperandInstruction;
import org.jobrunr.jobs.details.instructions.IStoreInstruction;
import org.jobrunr.jobs.details.instructions.InvokeDynamicInstruction;
import org.jobrunr.jobs.details.instructions.InvokeInterfaceInstruction;
import org.jobrunr.jobs.details.instructions.InvokeSpecialInstruction;
import org.jobrunr.jobs.details.instructions.InvokeStaticInstruction;
import org.jobrunr.jobs.details.instructions.InvokeVirtualInstruction;
import org.jobrunr.jobs.details.instructions.LConst0OperandInstruction;
import org.jobrunr.jobs.details.instructions.LConst1OperandInstruction;
import org.jobrunr.jobs.details.instructions.LLoadOperandInstruction;
import org.jobrunr.jobs.details.instructions.LStoreInstruction;
import org.jobrunr.jobs.details.instructions.LdcInstruction;
import org.jobrunr.jobs.details.instructions.NewOperandInstruction;
import org.jobrunr.jobs.details.instructions.PopOperandInstruction;
import org.jobrunr.jobs.details.instructions.ReturnOperandInstruction;
import org.jobrunr.jobs.details.instructions.SingleIntOperandInstruction;
import org.jobrunr.jobs.details.instructions.SwapOperandInstruction;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class AllJVMInstructions {
    private static final Map<Integer, Function<JobDetailsBuilder, AbstractJVMInstruction>> instructions = new HashMap<Integer, Function<JobDetailsBuilder, AbstractJVMInstruction>>();
    private static final Map<Integer, String> unsupportedInstructions = new HashMap<Integer, String>();

    private AllJVMInstructions() {
    }

    public static <T extends AbstractJVMInstruction> T get(int opcode, JobDetailsBuilder jobDetailsBuilder) {
        Function<JobDetailsBuilder, AbstractJVMInstruction> instructionBuilder = instructions.get(opcode);
        if (instructionBuilder == null) {
            if (unsupportedInstructions.containsKey(opcode)) {
                throw new IllegalArgumentException("Unsupported lambda", new UnsupportedOperationException(unsupportedInstructions.get(opcode)));
            }
            throw JobRunrException.shouldNotHappenException(new IllegalArgumentException("Instruction " + opcode + " not found"));
        }
        return (T)((AbstractJVMInstruction)ReflectionUtils.cast(instructionBuilder.apply(jobDetailsBuilder)));
    }

    static {
        instructions.put(83, AAStoreInstruction::new);
        instructions.put(25, ALoadOperandInstruction::new);
        instructions.put(189, ANewArrayOperandInstruction::new);
        instructions.put(58, AStoreInstruction::new);
        instructions.put(16, SingleIntOperandInstruction::new);
        instructions.put(192, CheckCastOperandInstruction::new);
        instructions.put(24, DLoadOperandInstruction::new);
        instructions.put(23, FLoadOperandInstruction::new);
        instructions.put(145, I2BOperandInstruction::new);
        instructions.put(146, I2COperandInstruction::new);
        instructions.put(135, I2DOperandInstruction::new);
        instructions.put(134, I2FOperandInstruction::new);
        instructions.put(133, I2LOperandInstruction::new);
        instructions.put(147, I2SOperandInstruction::new);
        instructions.put(3, IConst0OperandInstruction::new);
        instructions.put(4, IConst1OperandInstruction::new);
        instructions.put(5, IConst2OperandInstruction::new);
        instructions.put(6, IConst3OperandInstruction::new);
        instructions.put(7, IConst4OperandInstruction::new);
        instructions.put(8, IConst5OperandInstruction::new);
        instructions.put(186, InvokeDynamicInstruction::new);
        instructions.put(185, InvokeInterfaceInstruction::new);
        instructions.put(183, InvokeSpecialInstruction::new);
        instructions.put(184, InvokeStaticInstruction::new);
        instructions.put(182, InvokeVirtualInstruction::new);
        instructions.put(54, IStoreInstruction::new);
        instructions.put(55, LStoreInstruction::new);
        instructions.put(57, DStoreInstruction::new);
        instructions.put(56, FStoreInstruction::new);
        instructions.put(89, DupOperandInstruction::new);
        instructions.put(95, SwapOperandInstruction::new);
        instructions.put(21, ILoadOperandInstruction::new);
        instructions.put(9, LConst0OperandInstruction::new);
        instructions.put(10, LConst1OperandInstruction::new);
        instructions.put(18, LdcInstruction::new);
        instructions.put(22, LLoadOperandInstruction::new);
        instructions.put(187, NewOperandInstruction::new);
        instructions.put(87, PopOperandInstruction::new);
        instructions.put(180, GetFieldInstruction::new);
        instructions.put(178, GetStaticInstruction::new);
        instructions.put(177, ReturnOperandInstruction::new);
        instructions.put(17, SingleIntOperandInstruction::new);
        String mathematicalPerformanceSuffix = " - for performance reasons it is better to do the calculation outside of the job lambda";
        Arrays.asList(96, 97, 98, 99).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are summing two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(100, 101, 102, 103).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are subtracting two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(104, 105, 106, 107).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are multiplying two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(108, 109, 110, 111).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are dividing two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(112, 113, 114, 115).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are calculating the remainder (%) for two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
    }
}

