/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details.instructions;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.details.JobDetailsBuilder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.details.instructions.VisitMethodInstruction;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class InvokeSpecialInstruction
extends VisitMethodInstruction {
    public InvokeSpecialInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if ("<init>".equals(this.name)) {
            List<Object> parameters;
            Class<?>[] paramTypes;
            String className = JobDetailsGeneratorUtils.toFQClassName(this.owner);
            Object objectViaConstructor = JobDetailsGeneratorUtils.createObjectViaConstructor(className, paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor), (parameters = this.getParametersUsingParamTypes(paramTypes)).toArray());
            if (this.isKotlinMethodReference(objectViaConstructor)) {
                this.jobDetailsBuilder.setClassName(((Class)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "owner")).getName());
                this.jobDetailsBuilder.setMethodName((String)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "name"));
            }
            return objectViaConstructor;
        }
        String className = JobDetailsGeneratorUtils.toFQClassName(this.owner);
        Class objectClass = ReflectionUtils.toClass(className);
        Method method = ReflectionUtils.getMethod(objectClass, this.name, JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor));
        if (Modifier.isPrivate(method.getModifiers())) {
            throw JobRunrException.invalidLambdaException(new IllegalAccessException(String.format("JobRunr cannot access member \"%s\" of class %s with modifiers \"private\". Please make the method \"public\".", this.name, className)));
        }
        throw JobRunrException.shouldNotHappenException("Unknown INVOKESPECIAL instruction: " + className + "." + this.name);
    }

    private boolean isKotlinMethodReference(Object objectViaConstructor) {
        return Arrays.stream(objectViaConstructor.getClass().getInterfaces()).map(Class::getName).anyMatch(name -> name.startsWith("kotlin.jvm.functions.Function"));
    }
}

