/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.annotations.Job;
import org.jobrunr.jobs.filters.ElectStateFilter;
import org.jobrunr.jobs.filters.JobDefaultFilters;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.scheduling.exceptions.JobNotFoundException;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;

public abstract class AbstractJobFilters {
    protected final AbstractJob job;
    protected final List<JobFilter> jobFilters;

    protected AbstractJobFilters(AbstractJob job, JobDefaultFilters jobDefaultFilters) {
        this.job = job;
        this.jobFilters = this.initJobFilters(job, jobDefaultFilters.getFilters());
    }

    protected List<JobFilter> initJobFilters(AbstractJob job, List<JobFilter> jobFilters) {
        try {
            ArrayList<JobFilter> result = new ArrayList<JobFilter>(jobFilters);
            AbstractJobFilters.keepOnlyLastElectStateFilter(result);
            AbstractJobFilters.addJobFiltersFromJobAnnotation(job, result);
            return result;
        }
        catch (JobNotFoundException e) {
            return Collections.emptyList();
        }
    }

    abstract Logger getLogger();

    private static void keepOnlyLastElectStateFilter(List<JobFilter> result) {
        if (AbstractJobFilters.hasMultipleElectStateFilters(result)) {
            ElectStateFilter firstElectStateFilter = AbstractJobFilters.findFirstElectStateFilter(result);
            result.remove(firstElectStateFilter);
        }
    }

    private static void addJobFiltersFromJobAnnotation(AbstractJob job, List<JobFilter> result) {
        Optional<Job> jobAnnotation = JobUtils.getJobAnnotation(job.getJobDetails());
        if (jobAnnotation.isPresent()) {
            Optional<ElectStateFilter> electStateFilter = AbstractJobFilters.getElectStateFilter(jobAnnotation.get());
            if (electStateFilter.isPresent()) {
                result.removeIf(jobFilter -> ElectStateFilter.class.isAssignableFrom(jobFilter.getClass()));
                result.add(electStateFilter.get());
            }
            result.addAll(AbstractJobFilters.getOtherJobFilter(jobAnnotation.get()));
        }
    }

    private static boolean hasMultipleElectStateFilters(List<JobFilter> result) {
        return result.stream().filter(jobFilter -> ElectStateFilter.class.isAssignableFrom(jobFilter.getClass())).count() > 1L;
    }

    private static ElectStateFilter findFirstElectStateFilter(List<JobFilter> result) {
        return result.stream().filter(jobFilter -> ElectStateFilter.class.isAssignableFrom(jobFilter.getClass())).map(ElectStateFilter.class::cast).findFirst().orElseThrow(() -> JobRunrException.shouldNotHappenException("Can not happen..."));
    }

    private static Optional<ElectStateFilter> getElectStateFilter(Job jobAnnotation) {
        return Stream.of(jobAnnotation.jobFilters()).filter(ElectStateFilter.class::isAssignableFrom).findFirst().map(ReflectionUtils::newInstance).map(ElectStateFilter.class::cast);
    }

    private static List<JobFilter> getOtherJobFilter(Job jobAnnotation) {
        return Stream.of(jobAnnotation.jobFilters()).filter(jobFilter -> !ElectStateFilter.class.isAssignableFrom((Class<?>)jobFilter)).map(AbstractJobFilters::createInstance).collect(Collectors.toList());
    }

    private static JobFilter createInstance(Class<? extends JobFilter> jobFilterClass) {
        try {
            return ReflectionUtils.newInstanceCE(jobFilterClass);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Do you want to use JobFilter Beans? This is only possible in the Pro version. Check out https://www.jobrunr.io/en/documentation/pro/job-filters/", e);
        }
    }

    <T extends JobFilter> Consumer<T> catchThrowable(Consumer<T> consumer) {
        return jobClientFilter -> {
            try {
                consumer.accept(jobClientFilter);
            }
            catch (Exception e) {
                this.getLogger().error("Error evaluating jobfilter {}", (Object)jobClientFilter.getClass().getName(), (Object)e);
            }
        };
    }
}

