/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.states;

import java.time.Instant;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.states.AbstractJobState;
import org.jobrunr.jobs.states.StateName;

public class ScheduledState
extends AbstractJobState {
    private Instant scheduledAt;
    private String recurringJobId;
    private String reason;

    protected ScheduledState() {
        this((Instant)null);
    }

    public ScheduledState(Instant scheduledAt) {
        this(scheduledAt, (String)null);
    }

    public ScheduledState(Instant scheduledAt, RecurringJob recurringJob) {
        this(scheduledAt, "Scheduled by recurring job '" + recurringJob.getJobName() + "'");
        this.recurringJobId = recurringJob.getId();
    }

    public ScheduledState(Instant scheduledAt, String reason) {
        super(StateName.SCHEDULED);
        this.scheduledAt = scheduledAt;
        this.reason = reason;
    }

    public Instant getScheduledAt() {
        return this.scheduledAt;
    }

    public String getRecurringJobId() {
        return this.recurringJobId;
    }

    public String getReason() {
        return this.reason;
    }
}

