/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.jobs.lambdas.JobRequest;
import org.jobrunr.jobs.lambdas.JobRunrJob;
import org.jobrunr.jobs.states.AbstractJobState;
import org.jobrunr.jobs.states.EnqueuedState;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.JobUtils;

public class JobBuilder {
    private UUID jobId;
    private String jobName;
    private Instant scheduleAt;
    private Integer retries;
    private Set<String> labels;
    private JobRunrJob jobLambda;
    private JobRequest jobRequest;

    private JobBuilder() {
    }

    public static JobBuilder aJob() {
        return new JobBuilder();
    }

    public JobBuilder withId(UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    public JobBuilder withName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public JobBuilder scheduleIn(Duration duration) {
        this.scheduleAt = Instant.now().plus(duration);
        return this;
    }

    public JobBuilder scheduleAt(Instant scheduleAt) {
        this.scheduleAt = scheduleAt;
        return this;
    }

    public JobBuilder withAmountOfRetries(int amountOfRetries) {
        this.retries = amountOfRetries;
        return this;
    }

    public JobBuilder withLabels(String ... labels) {
        return this.withLabels(CollectionUtils.asSet(labels));
    }

    public JobBuilder withLabels(Set<String> labels) {
        this.labels = labels;
        return this;
    }

    public JobBuilder withDetails(JobLambda jobLambda) {
        if (this.jobRequest != null) {
            throw new IllegalArgumentException("withJobRequest() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobLambda = jobLambda;
        return this;
    }

    public <S> JobBuilder withDetails(IocJobLambda<S> jobLambda) {
        if (this.jobRequest != null) {
            throw new IllegalArgumentException("withJobRequest() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobLambda = jobLambda;
        return this;
    }

    public JobBuilder withJobRequest(JobRequest jobRequest) {
        if (this.jobLambda != null) {
            throw new IllegalArgumentException("withJobLambda() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobRequest = jobRequest;
        return this;
    }

    protected Job build(JobDetailsGenerator jobDetailsGenerator) {
        if (this.jobLambda == null) {
            throw new IllegalArgumentException("A jobLambda must be present.");
        }
        JobDetails jobDetails = jobDetailsGenerator.toJobDetails(this.jobLambda);
        return this.build(jobDetails);
    }

    protected Job build() {
        if (this.jobRequest == null) {
            throw new IllegalArgumentException("JobRequest must be present.");
        }
        JobDetails jobDetails = new JobDetails(this.jobRequest);
        return this.build(jobDetails);
    }

    private Job build(JobDetails jobDetails) {
        if (JobUtils.getJobAnnotation(jobDetails).isPresent()) {
            throw new IllegalStateException("You are combining the JobBuilder with the Job annotation which is not allowed. You can only use one of them.");
        }
        Job job = new Job(this.jobId, jobDetails, this.getState());
        this.setJobName(job);
        this.setAmountOfRetries(job);
        this.setLabels(job);
        return job;
    }

    private void setJobName(Job job) {
        if (this.jobName != null) {
            job.setJobName(this.jobName);
        }
    }

    private void setAmountOfRetries(Job job) {
        if (this.retries != null) {
            job.setAmountOfRetries(this.retries);
        }
    }

    private void setLabels(Job job) {
        if (this.labels != null) {
            job.setLabels(this.labels);
        }
    }

    private AbstractJobState getState() {
        if (this.scheduleAt != null) {
            return new ScheduledState(this.scheduleAt);
        }
        return new EnqueuedState();
    }
}

