/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Set;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.jobs.lambdas.JobRequest;
import org.jobrunr.jobs.lambdas.JobRunrJob;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;
import org.jobrunr.utils.CollectionUtils;

public class RecurringJobBuilder {
    private String jobId;
    private String jobName;
    private Integer retries;
    private Set<String> labels;
    private JobRunrJob jobRunrJob;
    private JobRequest jobRequest;
    private Schedule schedule;
    private ZoneId zoneId;

    private RecurringJobBuilder() {
    }

    public static RecurringJobBuilder aRecurringJob() {
        return new RecurringJobBuilder();
    }

    public RecurringJobBuilder withId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public RecurringJobBuilder withName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public RecurringJobBuilder withAmountOfRetries(int amountOfRetries) {
        this.retries = amountOfRetries;
        return this;
    }

    public RecurringJobBuilder withLabels(String ... labels) {
        return this.withLabels(CollectionUtils.asSet(labels));
    }

    public RecurringJobBuilder withLabels(Set<String> labels) {
        this.labels = labels;
        return this;
    }

    public RecurringJobBuilder withDetails(JobLambda jobLambda) {
        if (this.jobRequest != null) {
            throw new IllegalArgumentException("withJobRequest() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobRunrJob = jobLambda;
        return this;
    }

    public <S> RecurringJobBuilder withDetails(IocJobLambda<S> ioCJobLambda) {
        if (this.jobRequest != null) {
            throw new IllegalArgumentException("withJobRequest() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobRunrJob = ioCJobLambda;
        return this;
    }

    public RecurringJobBuilder withJobRequest(JobRequest jobRequest) {
        if (this.jobRunrJob != null) {
            throw new IllegalArgumentException("withJobLambda() is already called, only 1 of [withDetails(), withJobRequest()] should be called.");
        }
        this.jobRequest = jobRequest;
        return this;
    }

    public RecurringJobBuilder withCron(String cron) {
        if (this.schedule != null) {
            throw new IllegalArgumentException("A schedule has already been provided.");
        }
        this.schedule = CronExpression.create(cron);
        return this;
    }

    public RecurringJobBuilder withDuration(Duration duration) {
        if (this.schedule != null) {
            throw new IllegalArgumentException("A schedule has already been provided.");
        }
        this.schedule = new Interval(duration);
        return this;
    }

    public RecurringJobBuilder withZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    protected RecurringJob build(JobDetailsGenerator jobDetailsGenerator) {
        if (this.jobRunrJob == null) {
            throw new IllegalArgumentException("JobLambda must be present.");
        }
        JobDetails jobDetails = jobDetailsGenerator.toJobDetails(this.jobRunrJob);
        return this.build(jobDetails);
    }

    protected RecurringJob build() {
        if (this.jobRequest == null) {
            throw new IllegalArgumentException("JobRequest must be present.");
        }
        JobDetails jobDetails = new JobDetails(this.jobRequest);
        return this.build(jobDetails);
    }

    private RecurringJob build(JobDetails jobDetails) {
        if (this.schedule == null) {
            throw new IllegalArgumentException("A schedule must be present. Please call withCron() or withDuration().");
        }
        if (this.zoneId == null) {
            this.zoneId = ZoneId.systemDefault();
        }
        RecurringJob recurringJob = new RecurringJob(this.jobId, jobDetails, this.schedule, this.zoneId);
        this.setJobName(recurringJob);
        this.setAmountOfRetries(recurringJob);
        this.setLabels(recurringJob);
        return recurringJob;
    }

    private void setJobName(RecurringJob recurringJob) {
        if (this.jobName != null) {
            recurringJob.setJobName(this.jobName);
        }
    }

    private void setAmountOfRetries(RecurringJob recurringJob) {
        if (this.retries != null) {
            recurringJob.setAmountOfRetries(this.retries);
        }
    }

    private void setLabels(RecurringJob recurringJob) {
        if (this.labels != null) {
            recurringJob.setLabels(this.labels);
        }
    }
}

