/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.util.Objects;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.ScheduleException;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;

public enum ScheduleExpressionType {
    CRON_EXPRESSION{

        @Override
        public Schedule createSchedule(String scheduleExpression) {
            return CronExpression.create(scheduleExpression);
        }
    }
    ,
    INTERVAL{

        @Override
        public Schedule createSchedule(String scheduleExpression) {
            return new Interval(scheduleExpression);
        }
    };


    public static Schedule getSchedule(String scheduleExpression) {
        if (Objects.nonNull(scheduleExpression) && !scheduleExpression.isEmpty()) {
            if (scheduleExpression.matches(".*\\s.*")) {
                return CRON_EXPRESSION.createSchedule(scheduleExpression);
            }
            if (scheduleExpression.startsWith("P")) {
                return INTERVAL.createSchedule(scheduleExpression);
            }
        }
        throw new ScheduleException(scheduleExpression);
    }

    public abstract Schedule createSchedule(String var1);
}

