/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling.interval;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import org.jobrunr.scheduling.Schedule;

public class Interval
extends Schedule {
    private final Duration duration;

    public Interval(Duration duration) {
        this.duration = duration;
    }

    public Interval(String durationExpression) {
        this.duration = Duration.parse(durationExpression);
    }

    @Override
    public Instant next(Instant createdAtInstant, Instant currentInstant, ZoneId zoneId) {
        Duration durationUntilNow = Duration.between(createdAtInstant, currentInstant);
        long amountOfDurationsUntilNow = durationUntilNow.toNanos() / this.duration.toNanos();
        return createdAtInstant.plusNanos(this.duration.toNanos() * (amountOfDurationsUntilNow + 1L));
    }

    @Override
    public void validateSchedule() {
        if (this.duration.getSeconds() < 5L) {
            throw new IllegalArgumentException(String.format("The smallest interval for recurring jobs is %d seconds. Please also make sure that your 'pollIntervalInSeconds' configuration matches the smallest recurring job interval.", 5));
        }
    }

    public String toString() {
        return this.duration.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Interval interval = (Interval)obj;
        return this.duration.equals(interval.duration);
    }

    @Override
    public int hashCode() {
        return this.duration.hashCode();
    }
}

