/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.zookeeper.ThreadIdleTaskInfo;
import org.jobrunr.server.zookeeper.ZooKeeperRunTaskInfo;
import org.jobrunr.server.zookeeper.ZooKeeperStatistics;
import org.jobrunr.server.zookeeper.tasks.DeleteDeletedJobsPermanentlyTask;
import org.jobrunr.server.zookeeper.tasks.DeleteSucceededJobsTask;
import org.jobrunr.server.zookeeper.tasks.OnboardNewWorkTask;
import org.jobrunr.server.zookeeper.tasks.ProcessOrphanedJobsTask;
import org.jobrunr.server.zookeeper.tasks.ProcessRecurringJobsTask;
import org.jobrunr.server.zookeeper.tasks.ProcessScheduledJobsTask;
import org.jobrunr.server.zookeeper.tasks.UpdateJobsInProgressTask;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobZooKeeper
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(JobZooKeeper.class);
    private final BackgroundJobServer backgroundJobServer;
    private final Map<Job, Thread> jobsCurrentlyInProgress;
    private final ZooKeeperStatistics zooKeeperStatistics;
    private final AtomicInteger occupiedWorkers;
    private final ZooKeeperTask updateJobsInProgressTask;
    private final ZooKeeperTask onboardNewWorkTask;
    private final List<ZooKeeperTask> masterTasks;

    public JobZooKeeper(BackgroundJobServer backgroundJobServer) {
        this.backgroundJobServer = backgroundJobServer;
        this.zooKeeperStatistics = new ZooKeeperStatistics(backgroundJobServer.getDashboardNotificationManager());
        this.updateJobsInProgressTask = new UpdateJobsInProgressTask(this, backgroundJobServer);
        this.onboardNewWorkTask = new OnboardNewWorkTask(this, backgroundJobServer);
        this.masterTasks = Arrays.asList(new ProcessRecurringJobsTask(this, backgroundJobServer), new ProcessScheduledJobsTask(this, backgroundJobServer), new ProcessOrphanedJobsTask(this, backgroundJobServer), new DeleteSucceededJobsTask(this, backgroundJobServer), new DeleteDeletedJobsPermanentlyTask(this, backgroundJobServer));
        this.jobsCurrentlyInProgress = new ConcurrentHashMap<Job, Thread>();
        this.occupiedWorkers = new AtomicInteger();
    }

    @Override
    public void run() {
        if (this.backgroundJobServer.isUnAnnounced()) {
            return;
        }
        try (ZooKeeperRunTaskInfo runInfo = this.zooKeeperStatistics.startRun(this.backgroundJobServerConfiguration());){
            this.updateJobsThatAreBeingProcessed(runInfo);
            this.runMasterTasksIfCurrentServerIsMaster(runInfo);
            this.onboardNewWorkIfPossible(runInfo);
            runInfo.markRunAsSucceeded();
        }
        catch (Exception e) {
            this.zooKeeperStatistics.handleException(e);
            if (this.zooKeeperStatistics.hasTooManyExceptions()) {
                if (e instanceof StorageException) {
                    LOGGER.error("FATAL - JobRunr encountered too many storage exceptions. Shutting down. Did you know JobRunr Pro has built-in database fault tolerance? Check out https://www.jobrunr.io/en/documentation/pro/database-fault-tolerance/", (Throwable)e);
                } else {
                    LOGGER.error("FATAL - JobRunr encountered too many processing exceptions. Shutting down.", (Throwable)JobRunrException.shouldNotHappenException(e));
                }
                this.backgroundJobServer.stop();
            }
            LOGGER.warn("JobRunr encountered a problematic exception. Please create a bug report (if possible, provide the code to reproduce this and the stacktrace) - Processing will continue.", (Throwable)e);
        }
    }

    void updateJobsThatAreBeingProcessed(ZooKeeperRunTaskInfo runInfo) {
        this.updateJobsInProgressTask.run(runInfo);
    }

    void runMasterTasksIfCurrentServerIsMaster(ZooKeeperRunTaskInfo runInfo) {
        if (this.backgroundJobServer.isMaster()) {
            this.masterTasks.forEach(task -> task.run(runInfo));
        }
    }

    void onboardNewWorkIfPossible(ZooKeeperRunTaskInfo runInfo) {
        this.onboardNewWorkTask.run(runInfo);
    }

    BackgroundJobServerConfiguration backgroundJobServerConfiguration() {
        return this.backgroundJobServer.getConfiguration();
    }

    public void startProcessing(Job job, Thread thread) {
        this.jobsCurrentlyInProgress.put(job, thread);
    }

    public void stopProcessing(Job job) {
        this.jobsCurrentlyInProgress.remove(job);
    }

    public Set<Job> getJobsInProgress() {
        return this.jobsCurrentlyInProgress.keySet();
    }

    public Thread getThreadProcessingJob(Job job) {
        return this.jobsCurrentlyInProgress.get(job);
    }

    public int getOccupiedWorkerCount() {
        return this.occupiedWorkers.get();
    }

    public void notifyThreadOccupied() {
        this.occupiedWorkers.incrementAndGet();
    }

    public void notifyThreadIdle() {
        this.occupiedWorkers.decrementAndGet();
        this.onboardNewWorkTask.run(new ThreadIdleTaskInfo(this.backgroundJobServerConfiguration()));
    }
}

