/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent.statechanges;

import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.states.FailedState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.statechanges.AllowedConcurrentStateChange;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.annotations.Because;

@Because(value={"https://github.com/jobrunr/jobrunr/issues/557", "https://github.com/jobrunr/jobrunr/issues/553"})
public class ScheduledTooEarlyByJobZooKeeperConcurrentStateChange
implements AllowedConcurrentStateChange {
    private final StorageProvider storageProvider;

    public ScheduledTooEarlyByJobZooKeeperConcurrentStateChange(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public boolean matches(Job localJob, Job storageProviderJob) {
        return AllowedConcurrentStateChange.super.matches(localJob, storageProviderJob) && localJob.getVersion() == storageProviderJob.getVersion() - 1 && localJob.getLastJobStateOfType(FailedState.class).isPresent();
    }

    @Override
    public boolean matches(StateName localState, StateName storageProviderState) {
        return localState == StateName.ENQUEUED && storageProviderState == StateName.SCHEDULED;
    }

    @Override
    public ConcurrentJobModificationResolveResult resolve(Job localJob, Job storageProviderJob) {
        new JobVersioner(localJob);
        this.storageProvider.save(localJob);
        return ConcurrentJobModificationResolveResult.succeeded(localJob);
    }
}

