/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobServerStats {
    private final OperatingSystemMXBean operatingSystemMXBean;
    private final MBeanServer platformMBeanServer;
    private final ConcurrentMap<String, Object> cachedValues = new ConcurrentHashMap<String, Object>();

    public JobServerStats() {
        this(JobServerStats.getOperatingSystemMXBean(), JobServerStats.getPlatformMBeanServer());
    }

    protected JobServerStats(OperatingSystemMXBean operatingSystemMXBean, MBeanServer platformMBeanServer) {
        this.operatingSystemMXBean = operatingSystemMXBean;
        this.platformMBeanServer = platformMBeanServer;
    }

    public Long getProcessMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public Long getProcessFreeMemory() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public Long getProcessAllocatedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public Long getSystemTotalMemory() {
        return this.getMXBeanValueAsLong("TotalPhysicalMemorySize");
    }

    public Long getSystemFreeMemory() {
        return this.getMXBeanValueAsLong("FreePhysicalMemorySize");
    }

    public Double getSystemCpuLoad() {
        return this.getMXBeanValueAsDouble("SystemCpuLoad");
    }

    public Double getProcessCpuLoad() {
        return this.getMXBeanValueAsDouble("ProcessCpuLoad");
    }

    private Double getMXBeanValueAsDouble(String name) {
        double value = ((Number)this.getMXBeanValue(name)).doubleValue();
        if (!Double.isNaN(value)) {
            this.cachedValues.put(name, value);
        }
        return (Double)ReflectionUtils.cast(this.cachedValues.getOrDefault(name, -1.0));
    }

    private Long getMXBeanValueAsLong(String name) {
        long value = ((Number)this.getMXBeanValue(name)).longValue();
        if (value > 0L) {
            this.cachedValues.put(name, value);
        }
        return (Long)ReflectionUtils.cast(this.cachedValues.getOrDefault(name, -1L));
    }

    <O> O getMXBeanValue(String name) {
        if (this.platformMBeanServer == null || this.operatingSystemMXBean == null) {
            return (O)ReflectionUtils.cast(-1);
        }
        try {
            Object attribute = this.platformMBeanServer.getAttribute(this.operatingSystemMXBean.getObjectName(), name);
            return (O)ReflectionUtils.cast(attribute);
        }
        catch (Throwable ex) {
            return (O)ReflectionUtils.cast(-1);
        }
    }

    private static OperatingSystemMXBean getOperatingSystemMXBean() {
        try {
            return ManagementFactory.getOperatingSystemMXBean();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            return null;
        }
    }

    private static MBeanServer getPlatformMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            return null;
        }
    }
}

