/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.runner;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.IntStream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.server.runner.BackgroundJobRunner;
import org.jobrunr.server.runner.RunnerJobContext;
import org.jobrunr.server.runner.ThreadLocalJobContext;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public abstract class AbstractBackgroundJobRunner
implements BackgroundJobRunner {
    protected abstract BackgroundJobWorker getBackgroundJobWorker(Job var1);

    @Override
    public void run(Job job) throws Exception {
        this.getBackgroundJobWorker(job).run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected static class BackgroundJobWorker {
        protected final Job job;
        protected final JobDetails jobDetails;

        public BackgroundJobWorker(Job job) {
            this.job = job;
            this.jobDetails = job.getJobDetails();
        }

        public void run() throws Exception {
            Class<?> jobToPerformClass = this.getJobToPerformClass();
            Object jobToPerform = this.getJobToPerform(jobToPerformClass);
            Method jobMethodToPerform = this.getJobMethodToPerform(jobToPerformClass);
            this.invokeJobMethod(jobToPerform, jobMethodToPerform);
        }

        protected Class<?> getJobToPerformClass() {
            return JobUtils.getJobClass(this.jobDetails);
        }

        protected Object getJobToPerform(Class<?> jobToPerformClass) {
            return ReflectionUtils.newInstance(jobToPerformClass);
        }

        protected Method getJobMethodToPerform(Class<?> jobToPerformClass) {
            return JobUtils.getJobMethod(jobToPerformClass, this.jobDetails);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeJobMethod(Object jobToPerform, Method jobMethodToPerform) throws Exception {
            Object[] jobParameterValues = this.jobDetails.getJobParameterValues();
            List<JobParameter> jobParameters = this.jobDetails.getJobParameters();
            IntStream.range(0, jobParameters.size()).filter(i -> ((JobParameter)jobParameters.get(i)).getClassName().equals(JobContext.class.getName())).findFirst().ifPresent(index -> {
                jobParameterValues[index] = this.getRunnerJobContext();
            });
            try {
                ThreadLocalJobContext.setJobContext(this.getRunnerJobContext());
                jobMethodToPerform.invoke(jobToPerform, jobParameterValues);
            }
            finally {
                ThreadLocalJobContext.clear();
            }
        }

        protected RunnerJobContext getRunnerJobContext() {
            return new RunnerJobContext(this.job);
        }
    }
}

