/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.runner;

import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.runner.AbstractBackgroundJobRunner;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class BackgroundJobWithIocRunner
extends AbstractBackgroundJobRunner {
    private final JobActivator jobActivator;

    public BackgroundJobWithIocRunner(JobActivator jobActivator) {
        this.jobActivator = jobActivator;
    }

    @Override
    public boolean supports(Job job) {
        if (this.jobActivator == null) {
            return false;
        }
        JobDetails jobDetails = job.getJobDetails();
        return !jobDetails.hasStaticFieldName() && this.jobActivator.activateJob(ReflectionUtils.toClass(jobDetails.getClassName())) != null;
    }

    @Override
    protected AbstractBackgroundJobRunner.BackgroundJobWorker getBackgroundJobWorker(Job job) {
        return new BackgroundForIoCJobLambdaWorker(this.jobActivator, job);
    }

    protected static class BackgroundForIoCJobLambdaWorker
    extends AbstractBackgroundJobRunner.BackgroundJobWorker {
        private final JobActivator jobActivator;

        public BackgroundForIoCJobLambdaWorker(JobActivator jobActivator, Job job) {
            super(job);
            this.jobActivator = jobActivator;
        }

        @Override
        protected Object getJobToPerform(Class<?> jobToPerformClass) {
            return this.jobActivator.activateJob(jobToPerformClass);
        }
    }
}

