/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.strategy;

import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.strategy.WorkDistributionStrategy;
import org.jobrunr.storage.PageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicWorkDistributionStrategy
implements WorkDistributionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicWorkDistributionStrategy.class);
    private final BackgroundJobServer backgroundJobServer;
    private final int workerCount;

    public BasicWorkDistributionStrategy(BackgroundJobServer backgroundJobServer, int workerCount) {
        this.backgroundJobServer = backgroundJobServer;
        this.workerCount = workerCount;
    }

    @Override
    public int getWorkerCount() {
        return this.workerCount;
    }

    @Override
    public boolean canOnboardNewWork() {
        double occupiedWorkerCount = this.getOccupiedWorkerCount();
        boolean canOnboardWork = occupiedWorkerCount / (double)this.workerCount < 0.7;
        return canOnboardWork;
    }

    @Override
    public PageRequest getWorkPageRequest() {
        int occupiedWorkerCount = this.getOccupiedWorkerCount();
        int limit = this.workerCount - occupiedWorkerCount;
        LOGGER.debug("Can onboard {} new work (occupiedWorkerCount = {}; workerCount = {}).", new Object[]{limit, occupiedWorkerCount, this.workerCount});
        return PageRequest.ascOnUpdatedAt(limit);
    }

    private int getOccupiedWorkerCount() {
        return this.backgroundJobServer.getJobZooKeeper().getOccupiedWorkerCount();
    }
}

