/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Instant;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;

public class DeleteDeletedJobsPermanentlyTask
extends ZooKeeperTask {
    public DeleteDeletedJobsPermanentlyTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
    }

    @Override
    protected void runTask() {
        LOGGER.trace("Looking for deleted jobs that can be deleted permanently...");
        int totalAmountOfPermanentlyDeletedJobs = this.storageProvider.deleteJobsPermanently(StateName.DELETED, Instant.now().minus(this.backgroundJobServerConfiguration().getDeleteSucceededJobsAfter()));
        LOGGER.debug("Found {} deleted jobs that were permanently deleted as part of JobRunr maintenance", (Object)totalAmountOfPermanentlyDeletedJobs);
    }
}

