/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.PageRequest;

public class DeleteSucceededJobsTask
extends ZooKeeperTask {
    private final int pageRequestSize;

    public DeleteSucceededJobsTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getSucceededJobsRequestSize();
    }

    @Override
    protected void runTask() {
        LOGGER.trace("Looking for succeeded jobs that can go to the deleted state... ");
        Instant updatedBefore = Instant.now().minus(this.backgroundJobServerConfiguration().getDeleteSucceededJobsAfter());
        Supplier<List<Job>> succeededJobsSupplier = () -> this.storageProvider.getJobs(StateName.SUCCEEDED, updatedBefore, PageRequest.ascOnUpdatedAt(this.pageRequestSize));
        this.processJobList(succeededJobsSupplier, job -> job.delete("JobRunr maintenance - deleting succeeded job"), this::handleTotalAmountOfSucceededJobs);
    }

    private void handleTotalAmountOfSucceededJobs(int totalAmountOfSucceededJobs) {
        if (totalAmountOfSucceededJobs > 0) {
            this.storageProvider.publishTotalAmountOfSucceededJobs(totalAmountOfSucceededJobs);
        }
        LOGGER.debug("Found {} succeeded jobs that moved to DELETED state as part of JobRunr maintenance", (Object)totalAmountOfSucceededJobs);
    }
}

