/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.PageRequest;

public class ProcessOrphanedJobsTask
extends ZooKeeperTask {
    private final int pageRequestSize;

    public ProcessOrphanedJobsTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getOrphanedJobsRequestSize();
    }

    @Override
    protected void runTask() {
        LOGGER.trace("Looking for orphan jobs... ");
        Instant updatedBefore = this.runStartTime().minus(Duration.ofSeconds(this.backgroundJobServerConfiguration().getPollIntervalInSeconds()).multipliedBy(4L));
        Supplier<List<Job>> orphanedJobsSupplier = () -> this.storageProvider.getJobs(StateName.PROCESSING, updatedBefore, PageRequest.ascOnUpdatedAt(this.pageRequestSize));
        this.processJobList(orphanedJobsSupplier, job -> job.failed("Orphaned job", new IllegalThreadStateException("Job was too long in PROCESSING state without being updated.")), totalAmountOfOrphanedJobs -> LOGGER.debug("Found {} orphan jobs.", totalAmountOfOrphanedJobs));
    }
}

