/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.PageRequest;

public class ProcessScheduledJobsTask
extends ZooKeeperTask {
    private final int pageRequestSize;

    public ProcessScheduledJobsTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
        this.pageRequestSize = backgroundJobServer.getConfiguration().getScheduledJobsRequestSize();
    }

    @Override
    protected void runTask() {
        LOGGER.trace("Looking for scheduled jobs... ");
        Supplier<List<Job>> scheduledJobsSupplier = () -> this.storageProvider.getScheduledJobs(Instant.now().plusSeconds(this.backgroundJobServerConfiguration().getPollIntervalInSeconds()), PageRequest.ascOnUpdatedAt(this.pageRequestSize));
        this.processJobList(scheduledJobsSupplier, Job::enqueue, totalAmountOfEnqueuedJobs -> LOGGER.debug("Found {} scheduled jobs to enqueue.", totalAmountOfEnqueuedJobs));
    }
}

