/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jobrunr.SevereJobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.filters.JobFilterUtils;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolver;
import org.jobrunr.server.concurrent.UnresolvableConcurrentJobModificationException;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTaskInfo;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JobZooKeeper.class);
    private final JobFilterUtils jobFilterUtils;
    private final ConcurrentJobModificationResolver concurrentJobModificationResolver;
    protected final JobZooKeeper jobZooKeeper;
    protected final BackgroundJobServer backgroundJobServer;
    protected final StorageProvider storageProvider;
    protected ZooKeeperTaskInfo runInfo;

    protected ZooKeeperTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        this.jobZooKeeper = jobZooKeeper;
        this.backgroundJobServer = backgroundJobServer;
        this.storageProvider = backgroundJobServer.getStorageProvider();
        this.jobFilterUtils = new JobFilterUtils(backgroundJobServer.getJobFilters());
        this.concurrentJobModificationResolver = this.createConcurrentJobModificationResolver();
    }

    public void run(ZooKeeperTaskInfo runInfo) {
        try {
            this.runInfo = runInfo;
            if (this.pollIntervalInSecondsTimeBoxIsAboutToPass()) {
                return;
            }
            this.runTask();
        }
        finally {
            this.runInfo = null;
        }
    }

    protected abstract void runTask();

    protected void processJobList(Supplier<List<Job>> jobListSupplier, Consumer<Job> jobConsumer, Consumer<Integer> amountOfProcessedJobsConsumer) {
        int amountOfProcessedJobs = 0;
        List<Job> jobs = this.getJobsToProcess(jobListSupplier);
        while (!jobs.isEmpty()) {
            this.processJobList(jobs, jobConsumer);
            amountOfProcessedJobs += jobs.size();
            jobs = this.getJobsToProcess(jobListSupplier);
        }
        amountOfProcessedJobsConsumer.accept(amountOfProcessedJobs);
    }

    protected void processJobList(List<Job> jobs, Consumer<Job> jobConsumer) {
        if (!jobs.isEmpty()) {
            try {
                jobs.forEach(jobConsumer);
                this.jobFilterUtils.runOnStateElectionFilter(jobs);
                this.storageProvider.save(jobs);
                this.jobFilterUtils.runOnStateAppliedFilters(jobs);
            }
            catch (ConcurrentJobModificationException concurrentJobModificationException) {
                try {
                    this.concurrentJobModificationResolver.resolve(concurrentJobModificationException);
                }
                catch (UnresolvableConcurrentJobModificationException unresolvableConcurrentJobModificationException) {
                    throw new SevereJobRunrException("Could not resolve ConcurrentJobModificationException", unresolvableConcurrentJobModificationException);
                }
            }
        }
    }

    private List<Job> getJobsToProcess(Supplier<List<Job>> jobListSupplier) {
        if (this.pollIntervalInSecondsTimeBoxIsAboutToPass()) {
            return Collections.emptyList();
        }
        return jobListSupplier.get();
    }

    protected BackgroundJobServerConfiguration configuration() {
        return this.backgroundJobServer.getConfiguration();
    }

    private boolean pollIntervalInSecondsTimeBoxIsAboutToPass() {
        return this.runInfo.pollIntervalInSecondsTimeBoxIsAboutToPass();
    }

    ConcurrentJobModificationResolver createConcurrentJobModificationResolver() {
        return this.backgroundJobServer.getConfiguration().getConcurrentJobModificationPolicy().toConcurrentJobModificationResolver(this.storageProvider, this.jobZooKeeper);
    }

    BackgroundJobServerConfiguration backgroundJobServerConfiguration() {
        return this.runInfo.getBackgroundJobServerConfiguration();
    }

    Instant runStartTime() {
        return this.runInfo.getRunStartTime();
    }
}

