/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.storage.StorageException;

public class ConcurrentJobModificationException
extends StorageException {
    private final List<Job> concurrentUpdatedJobs;

    public ConcurrentJobModificationException(Job concurrentUpdatedJob) {
        this(Collections.singletonList(concurrentUpdatedJob));
    }

    public ConcurrentJobModificationException(List<Job> concurrentUpdatedJobs) {
        super("The following jobs where concurrently updated: " + concurrentUpdatedJobs.stream().map(job -> job.getId().toString()).collect(Collectors.joining(", ")));
        this.concurrentUpdatedJobs = concurrentUpdatedJobs;
    }

    public List<Job> getConcurrentUpdatedJobs() {
        return this.concurrentUpdatedJobs;
    }
}

