/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.resilience.RateLimiter;

public class InMemoryStorageProvider
extends AbstractStorageProvider {
    private final Map<UUID, Job> jobQueue = new ConcurrentHashMap<UUID, Job>();
    private final Map<UUID, BackgroundJobServerStatus> backgroundJobServers = new ConcurrentHashMap<UUID, BackgroundJobServerStatus>();
    private final List<RecurringJob> recurringJobs = new CopyOnWriteArrayList<RecurringJob>();
    private final Map<String, JobRunrMetadata> metadata = new ConcurrentHashMap<String, JobRunrMetadata>();
    private JobMapper jobMapper;

    public InMemoryStorageProvider() {
        this(RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public InMemoryStorageProvider(RateLimiter rateLimiter) {
        super(rateLimiter);
        this.publishTotalAmountOfSucceededJobs(0);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        BackgroundJobServerStatus backgroundJobServerStatus = new BackgroundJobServerStatus(serverStatus.getId(), serverStatus.getName(), serverStatus.getWorkerPoolSize(), serverStatus.getPollIntervalInSeconds(), serverStatus.getDeleteSucceededJobsAfter(), serverStatus.getPermanentlyDeleteDeletedJobsAfter(), serverStatus.getFirstHeartbeat(), serverStatus.getLastHeartbeat(), serverStatus.isRunning(), serverStatus.getSystemTotalMemory(), serverStatus.getSystemFreeMemory(), serverStatus.getSystemCpuLoad(), serverStatus.getProcessMaxMemory(), serverStatus.getProcessFreeMemory(), serverStatus.getProcessAllocatedMemory(), serverStatus.getProcessCpuLoad());
        this.backgroundJobServers.put(serverStatus.getId(), backgroundJobServerStatus);
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        if (!this.backgroundJobServers.containsKey(serverStatus.getId())) {
            throw new ServerTimedOutException(serverStatus, new StorageException("Tha server is not there"));
        }
        this.announceBackgroundJobServer(serverStatus);
        BackgroundJobServerStatus backgroundJobServerStatus = this.backgroundJobServers.get(serverStatus.getId());
        return backgroundJobServerStatus.isRunning();
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        this.backgroundJobServers.remove(serverStatus.getId());
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        return this.backgroundJobServers.values().stream().sorted(Comparator.comparing(BackgroundJobServerStatus::getFirstHeartbeat)).collect(Collectors.toList());
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        return this.backgroundJobServers.values().stream().min(Comparator.comparing(BackgroundJobServerStatus::getFirstHeartbeat)).map(BackgroundJobServerStatus::getId).orElseThrow(() -> new IllegalStateException("No servers available?!"));
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        List serversToRemove = this.backgroundJobServers.entrySet().stream().filter(entry -> ((BackgroundJobServerStatus)entry.getValue()).getLastHeartbeat().isBefore(heartbeatOlderThan)).map(Map.Entry::getKey).collect(Collectors.toList());
        this.backgroundJobServers.keySet().removeAll(serversToRemove);
        return serversToRemove.size();
    }

    @Override
    public Job getJobById(UUID id) {
        if (!this.jobQueue.containsKey(id)) {
            throw new JobNotFoundException(id);
        }
        return this.deepClone(this.jobQueue.get(id));
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        this.metadata.put(metadata.getName() + "-" + metadata.getOwner(), metadata);
        this.notifyMetadataChangeListeners();
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String key) {
        return this.metadata.values().stream().filter(m -> m.getName().equals(key)).collect(Collectors.toList());
    }

    @Override
    public JobRunrMetadata getMetadata(String key, String owner) {
        return this.metadata.get(key + "-" + owner);
    }

    @Override
    public void deleteMetadata(String key) {
        List metadataToRemove = this.metadata.values().stream().filter(metadata -> metadata.getName().equals(key)).map(JobRunrMetadata::getId).collect(Collectors.toList());
        if (!metadataToRemove.isEmpty()) {
            this.metadata.keySet().removeAll(metadataToRemove);
            this.notifyMetadataChangeListeners();
        }
    }

    @Override
    public Job save(Job job) {
        this.saveJob(job);
        this.notifyJobStatsOnChangeListeners();
        return job;
    }

    @Override
    public int deletePermanently(UUID id) {
        boolean removed = this.jobQueue.keySet().remove(id);
        this.notifyJobStatsOnChangeListenersIf(removed);
        return removed ? 1 : 0;
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        List<Job> concurrentModifiedJobs = StorageProviderUtils.returnConcurrentModifiedJobs(jobs, this::saveJob);
        if (!concurrentModifiedJobs.isEmpty()) {
            throw new ConcurrentJobModificationException(concurrentModifiedJobs);
        }
        this.notifyJobStatsOnChangeListeners();
        return jobs;
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        return this.getJobsStream(state, pageRequest).filter(job -> job.getUpdatedAt().isBefore(updatedBefore)).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        return this.getJobsStream(StateName.SCHEDULED, pageRequest).filter(job -> ((ScheduledState)job.getJobState()).getScheduledAt().isBefore(scheduledBefore)).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        return this.getJobsStream(state, pageRequest).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        return new Page<Job>(this.getJobsStream(state).count(), this.getJobs(state, pageRequest), pageRequest);
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        List jobsToRemove = this.jobQueue.values().stream().filter(job -> job.hasState(state)).filter(job -> job.getUpdatedAt().isBefore(updatedBefore)).map(Job::getId).collect(Collectors.toList());
        this.jobQueue.keySet().removeAll(jobsToRemove);
        this.notifyJobStatsOnChangeListenersIf(!jobsToRemove.isEmpty());
        return jobsToRemove.size();
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        return this.jobQueue.values().stream().filter(job -> Arrays.asList(states).contains((Object)job.getState())).map(AbstractJob::getJobSignature).collect(Collectors.toSet());
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        String actualJobSignature = JobUtils.getJobSignature(jobDetails);
        return this.jobQueue.values().stream().anyMatch(job -> Arrays.asList(states).contains((Object)job.getState()) && actualJobSignature.equals(JobUtils.getJobSignature(job.getJobDetails())));
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        return this.jobQueue.values().stream().anyMatch(job -> Arrays.asList(StateName.getStateNames(states)).contains((Object)job.getState()) && job.getRecurringJobId().map(actualRecurringJobId -> actualRecurringJobId.equals(recurringJobId)).orElse(false) != false);
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        this.deleteRecurringJob(recurringJob.getId());
        this.recurringJobs.add(recurringJob);
        return recurringJob;
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        return new RecurringJobsResult((Collection<RecurringJob>)this.recurringJobs);
    }

    @Override
    @Deprecated
    public long countRecurringJobs() {
        return this.recurringJobs.size();
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        Long currentResult = this.recurringJobs.stream().map(rj -> rj.getCreatedAt().toEpochMilli()).reduce(Long::sum).orElse(0L);
        return !currentResult.equals(recurringJobsUpdatedHash);
    }

    @Override
    public int deleteRecurringJob(String id) {
        this.recurringJobs.removeIf(job -> id.equals(job.getId()));
        return 0;
    }

    @Override
    public JobStats getJobStats() {
        return new JobStats(Instant.now(), Long.valueOf(this.jobQueue.size()), this.getJobsStream(StateName.SCHEDULED).count(), this.getJobsStream(StateName.ENQUEUED).count(), this.getJobsStream(StateName.PROCESSING).count(), this.getJobsStream(StateName.FAILED).count(), this.getJobsStream(StateName.SUCCEEDED).count(), this.getMetadata("succeeded-jobs-counter", "cluster").getValueAsLong(), this.getJobsStream(StateName.DELETED).count(), this.recurringJobs.size(), this.backgroundJobServers.size());
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        JobRunrMetadata metadata = this.metadata.computeIfAbsent("succeeded-jobs-counter-cluster", input -> new JobRunrMetadata("succeeded-jobs-counter", "cluster", new AtomicLong(0L).toString()));
        metadata.setValue(new AtomicLong(Long.parseLong(metadata.getValue()) + (long)amount).toString());
    }

    private Stream<Job> getJobsStream(StateName state, PageRequest pageRequest) {
        return this.getJobsStream(state).sorted(this.getJobComparator(pageRequest));
    }

    private Stream<Job> getJobsStream(StateName state) {
        return this.jobQueue.values().stream().filter(job -> job.hasState(state));
    }

    private Job deepClone(Job job) {
        String serializedJobAsString = this.jobMapper.serializeJob(job);
        Job result = this.jobMapper.deserializeJob(serializedJobAsString);
        ReflectionUtils.setFieldUsingAutoboxing("locker", (Object)result, ReflectionUtils.getValueFromFieldOrProperty(job, "locker"));
        return result;
    }

    private synchronized void saveJob(Job job) {
        Job oldJob = this.jobQueue.get(job.getId());
        if (oldJob != null && job.getVersion() != oldJob.getVersion() || oldJob == null && job.getVersion() > 0) {
            throw new ConcurrentJobModificationException(job);
        }
        try (JobVersioner jobVersioner = new JobVersioner(job);){
            this.jobQueue.put(job.getId(), this.deepClone(job));
            jobVersioner.commitVersion();
        }
    }

    private Comparator<Job> getJobComparator(PageRequest pageRequest) {
        String[] sortOns;
        ArrayList<Comparator<Job>> result = new ArrayList<Comparator<Job>>();
        for (String sortOn : sortOns = pageRequest.getOrder().split(",")) {
            String[] sortAndOrder = sortOn.split(":");
            String sortField = sortAndOrder[0];
            PageRequest.Order order = PageRequest.Order.ASC;
            if (sortAndOrder.length > 1) {
                order = PageRequest.Order.valueOf(sortAndOrder[1].toUpperCase());
            }
            Comparator<Job> comparator = null;
            if (sortField.equalsIgnoreCase("createdAt")) {
                comparator = Comparator.comparing(Job::getCreatedAt);
            } else if (sortField.equalsIgnoreCase("updatedAt")) {
                comparator = Comparator.comparing(Job::getUpdatedAt);
            } else {
                throw new IllegalStateException("An unsupported sortOrder was requested: " + sortField);
            }
            if (order == PageRequest.Order.DESC) {
                comparator = comparator.reversed();
            }
            result.add(comparator);
        }
        return result.stream().reduce(Comparator::thenComparing).orElse((a, b) -> 0);
    }
}

