/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.listeners.StorageProviderChangeListener;

public interface StorageProvider
extends AutoCloseable {
    public static final int BATCH_SIZE = 5000;

    public StorageProviderInfo getStorageProviderInfo();

    public void setJobMapper(JobMapper var1);

    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions var1);

    public void addJobStorageOnChangeListener(StorageProviderChangeListener var1);

    public void removeJobStorageOnChangeListener(StorageProviderChangeListener var1);

    public void announceBackgroundJobServer(BackgroundJobServerStatus var1);

    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus var1);

    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus var1);

    public List<BackgroundJobServerStatus> getBackgroundJobServers();

    public UUID getLongestRunningBackgroundJobServerId();

    public int removeTimedOutBackgroundJobServers(Instant var1);

    public void saveMetadata(JobRunrMetadata var1);

    public List<JobRunrMetadata> getMetadata(String var1);

    public JobRunrMetadata getMetadata(String var1, String var2);

    public void deleteMetadata(String var1);

    public Job save(Job var1) throws ConcurrentJobModificationException;

    public List<Job> save(List<Job> var1) throws ConcurrentJobModificationException;

    public Job getJobById(UUID var1) throws JobNotFoundException;

    default public Job getJobById(JobId jobId) throws JobNotFoundException {
        return this.getJobById(jobId.asUUID());
    }

    public List<Job> getJobs(StateName var1, Instant var2, PageRequest var3);

    public List<Job> getScheduledJobs(Instant var1, PageRequest var2);

    public List<Job> getJobs(StateName var1, PageRequest var2);

    public Page<Job> getJobPage(StateName var1, PageRequest var2);

    public int deletePermanently(UUID var1);

    public int deleteJobsPermanently(StateName var1, Instant var2);

    public Set<String> getDistinctJobSignatures(StateName ... var1);

    public boolean exists(JobDetails var1, StateName ... var2);

    public boolean recurringJobExists(String var1, StateName ... var2);

    public RecurringJob saveRecurringJob(RecurringJob var1);

    @Deprecated
    public long countRecurringJobs();

    public RecurringJobsResult getRecurringJobs();

    public boolean recurringJobsUpdated(Long var1);

    public int deleteRecurringJob(String var1);

    public JobStats getJobStats();

    public void publishTotalAmountOfSucceededJobs(int var1);

    @Override
    public void close();

    public static class StorageProviderInfo {
        private final StorageProvider storageProvider;

        protected StorageProviderInfo(StorageProvider storageProvider) {
            this.storageProvider = storageProvider;
        }

        public String getName() {
            return this.storageProvider.getClass().getSimpleName();
        }

        public Class<? extends StorageProvider> getImplementationClass() {
            return this.storageProvider.getClass();
        }
    }
}

