/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.common;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.common.migrations.DefaultNoSqlMigrationProvider;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigrationProvider;
import org.jobrunr.storage.nosql.common.migrations.RunningOnJava11OrLowerWithinFatJarNoSqlMigrationProvider;
import org.jobrunr.utils.RuntimeUtils;

public class NoSqlDatabaseMigrationsProvider {
    private List<Class<? extends NoSqlStorageProvider>> noSqlStorageProviderClasses;

    public NoSqlDatabaseMigrationsProvider(List<Class<? extends NoSqlStorageProvider>> noSqlStorageProviderClasses) {
        this.noSqlStorageProviderClasses = noSqlStorageProviderClasses;
    }

    public Stream<NoSqlMigration> getMigrations() {
        NoSqlMigrationProvider migrationProvider = this.getMigrationProvider();
        return this.getMigrations(migrationProvider);
    }

    protected Stream<NoSqlMigration> getMigrations(NoSqlMigrationProvider migrationProvider) {
        HashMap migrations = new HashMap();
        for (Class<? extends NoSqlStorageProvider> noSqlStorageProvider : this.noSqlStorageProviderClasses) {
            migrationProvider.getMigrations(noSqlStorageProvider).stream().filter(m -> m.getClassName().matches("^M[0-9]{3}_(.)*$")).forEach(m -> migrations.put(m.getClassName(), m));
        }
        return migrations.values().stream().sorted(Comparator.comparing(NoSqlMigration::getClassName));
    }

    private NoSqlMigrationProvider getMigrationProvider() {
        if (RuntimeUtils.getJvmVersion() < 12 && RuntimeUtils.isRunningFromNestedJar()) {
            return new RunningOnJava11OrLowerWithinFatJarNoSqlMigrationProvider();
        }
        return new DefaultNoSqlMigrationProvider();
    }
}

