/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.common.migrations;

import java.nio.file.Path;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class NoSqlMigrationByPath
implements NoSqlMigration {
    private final Path path;
    private final String className;
    private final Class<?> migrationClass;

    public NoSqlMigrationByPath(Path path) {
        this.path = path;
        this.className = path.getFileName().toString();
        this.migrationClass = ReflectionUtils.toClassFromPath(path);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> getMigrationClass() {
        return this.migrationClass;
    }

    public String toString() {
        return "NoSqlMigrationByPath{path=" + this.path + '}';
    }
}

