/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.common.migrations;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigrationByZipEntry;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigrationProvider;
import org.jobrunr.utils.annotations.VisibleFor;

public class RunningOnJava11OrLowerWithinFatJarNoSqlMigrationProvider
implements NoSqlMigrationProvider {
    @Override
    public List<NoSqlMigration> getMigrations(Class<?> clazz) {
        List<NoSqlMigration> list;
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        URLConnection urlConnection = location.openConnection();
        ZipInputStream zipInputStream = new ZipInputStream(urlConnection.getInputStream());
        try {
            list = this.getMigrationsFromZipInputStream(zipInputStream, clazz);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Unable to find migrations.", e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to load migrations from classpath.", e);
            }
        }
        zipInputStream.close();
        return list;
    }

    private List<NoSqlMigration> getMigrationsFromZipInputStream(ZipInputStream zipInputStream, Class<?> clazz) throws IOException, ClassNotFoundException {
        ArrayList<NoSqlMigration> result = new ArrayList<NoSqlMigration>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (this.isNoSqlMigration(clazz, zipEntry)) {
                result.add(new NoSqlMigrationByZipEntry(zipEntry.getName()));
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return result;
    }

    @VisibleFor(value="testing - Github Issue #416")
    boolean isNoSqlMigration(Class<?> clazz, ZipEntry zipEntry) {
        return zipEntry.getName().startsWith(clazz.getPackage().getName().replace(".", "/") + "/migrations") && zipEntry.getName().endsWith(".class");
    }
}

