/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDBCreator;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDocumentMapper;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.annotations.Beta;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.resilience.RateLimiter;

@Beta(note="The ElasticSearchStorageProvider is still in Beta. My first impression is that other StorageProviders are faster than ElasticSearch.")
public class ElasticSearchStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    public static final String DEFAULT_JOB_INDEX_NAME = "jobrunr_jobs";
    public static final String DEFAULT_RECURRING_JOB_INDEX_NAME = "jobrunr_recurring_jobs";
    public static final String DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME = "jobrunr_background_job_servers";
    public static final String DEFAULT_METADATA_INDEX_NAME = "jobrunr_metadata";
    public static final int MAX_SIZE = 10000;
    private final RestHighLevelClient client;
    private final String jobIndexName;
    private final String recurringJobIndexName;
    private final String backgroundJobServerIndexName;
    private final String metadataIndexName;
    private final String indexPrefix;
    private ElasticSearchDocumentMapper documentMapper;

    public ElasticSearchStorageProvider(String hostName, int port) {
        this(new HttpHost(hostName, port, "http"));
    }

    public ElasticSearchStorageProvider(HttpHost httpHost) {
        this(new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{httpHost})));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client) {
        this(client, (String)null);
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix) {
        this(client, indexPrefix, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, indexPrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, null, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter rateLimiter) {
        this(client, null, databaseOptions, rateLimiter);
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.client = client;
        this.indexPrefix = indexPrefix;
        this.setUpStorageProvider(databaseOptions);
        this.jobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_JOB_INDEX_NAME);
        this.recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_RECURRING_JOB_INDEX_NAME);
        this.backgroundJobServerIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME);
        this.metadataIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_METADATA_INDEX_NAME);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.documentMapper = new ElasticSearchDocumentMapper(jobMapper);
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions options) {
        ElasticSearchDBCreator creator = new ElasticSearchDBCreator(this, this.client, this.indexPrefix);
        if (StorageProviderUtils.DatabaseOptions.CREATE == options) {
            creator.runMigrations();
        } else {
            creator.validateIndices();
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus status) {
        try {
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest().index(this.backgroundJobServerIndexName)).id(status.getId().toString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.documentMapper.toXContentBuilderForInsert(status));
            this.client.index(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus status) {
        try {
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.backgroundJobServerIndexName)).id(status.getId().toString()).fetchSource(true).doc(this.documentMapper.toXContentBuilderForUpdate(status));
            UpdateResponse updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
            return (Boolean)ReflectionUtils.cast(updateResponse.getGetResult().getSource().getOrDefault("running", false));
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().getStatus() == 404) {
                throw new ServerTimedOutException(status, new StorageException(e));
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        try {
            String id = serverStatus.getId().toString();
            DeleteRequest request = new DeleteRequest(this.backgroundJobServerIndexName, id);
            this.client.delete((DeleteRequest)request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource(true).sort("firstHeartbeat", SortOrder.ASC).size(10000);
            SearchResponse search = this.client.search(new SearchRequest().indices(new String[]{this.backgroundJobServerIndexName}).source(source), RequestOptions.DEFAULT);
            return Stream.of(search.getHits().getHits()).map(this.documentMapper::toBackgroundJobServerStatus).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource(false).sort("firstHeartbeat", SortOrder.ASC).size(1);
            SearchResponse search = this.client.search(new SearchRequest().indices(new String[]{this.backgroundJobServerIndexName}).source(source), RequestOptions.DEFAULT);
            return UUID.fromString(search.getHits().getHits()[0].getId());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        long deleted = this.deleteByQuery(this.backgroundJobServerIndexName, (QueryBuilder)QueryBuilders.rangeQuery((String)"lastHeartbeat").to((Object)heartbeatOlderThan));
        this.notifyJobStatsOnChangeListenersIf(deleted > 0L);
        return (int)deleted;
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try {
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest().index(this.metadataIndexName)).id(metadata.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.documentMapper.toXContentBuilder(metadata));
            this.client.index(request, RequestOptions.DEFAULT);
            this.notifyMetadataChangeListeners();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name)).size(10000);
            SearchResponse response = this.client.search(new SearchRequest().indices(new String[]{this.metadataIndexName}).source(source), RequestOptions.DEFAULT);
            return Stream.of(response.getHits().getHits()).map(this.documentMapper::toMetadata).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        try {
            GetRequest request = new GetRequest(this.metadataIndexName, JobRunrMetadata.toId(name, owner));
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            return this.documentMapper.toMetadata(response);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void deleteMetadata(String name) {
        long deleted = this.deleteByQuery(this.metadataIndexName, (QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name));
        if (deleted > 0L) {
            this.notifyMetadataChangeListeners();
        }
    }

    private long deleteByQuery(String index, QueryBuilder query) {
        DeleteByQueryRequest request = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{index}).setQuery(query).setRefresh(true);
        try {
            BulkByScrollResponse response = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job save(Job job) {
        JobVersioner jobVersioner = new JobVersioner(job);
        try {
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest().index(this.jobIndexName)).id(job.getId().toString()).versionType(VersionType.EXTERNAL).version((long)job.getVersion()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.documentMapper.toXContentBuilder(job));
            this.client.index(request, RequestOptions.DEFAULT);
            jobVersioner.commitVersion();
            this.notifyJobStatsOnChangeListeners();
            Job job2 = job;
            jobVersioner.close();
            return job2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jobVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ElasticsearchException e) {
                if (e.status().getStatus() == 409) {
                    throw new ConcurrentJobModificationException(job);
                }
                throw new StorageException(e);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public int deletePermanently(UUID id) {
        try {
            DeleteRequest request = (DeleteRequest)((DeleteRequest)new DeleteRequest().index(this.jobIndexName)).id(id.toString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            DeleteResponse response = this.client.delete(request, RequestOptions.DEFAULT);
            int amountDeleted = response.getShardInfo().getSuccessful();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job getJobById(UUID id) {
        try {
            GetRequest request = ((GetRequest)new GetRequest().index(this.jobIndexName)).id(id.toString()).storedFields(new String[]{"jobAsJson"});
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            if (response.isExists()) {
                return this.documentMapper.toJob(response);
            }
            throw new JobNotFoundException(id);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        JobListVersioner versioner = new JobListVersioner(jobs);
        try {
            versioner.validateJobs();
            BulkRequest bulkRequest = new BulkRequest(this.jobIndexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            jobs.stream().map(job -> new IndexRequest().id(job.getId().toString()).versionType(VersionType.EXTERNAL).version((long)job.getVersion()).source(this.documentMapper.toXContentBuilder((Job)job))).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
            BulkResponse response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            List<Job> concurrentModifiedJobs = Stream.of(response.getItems()).filter(item -> item.isFailed() && item.status().getStatus() == 409).map(item -> (Job)jobs.get(item.getItemId())).collect(Collectors.toList());
            if (!concurrentModifiedJobs.isEmpty()) {
                versioner.rollbackVersions(concurrentModifiedJobs);
                throw new ConcurrentJobModificationException(concurrentModifiedJobs);
            }
            versioner.commitVersions();
            this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
            List<Job> list = jobs;
            versioner.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    versioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ElasticsearchException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        try {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"updatedAt").to((Object)updatedBefore));
            SearchResponse response = this.searchJobs((QueryBuilder)query, pageRequest);
            return Stream.of(response.getHits().getHits()).map(this.documentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        try {
            RangeQueryBuilder query = QueryBuilders.rangeQuery((String)"scheduledAt").to((Object)scheduledBefore);
            SearchResponse searchResponse = this.searchJobs((QueryBuilder)query, pageRequest);
            return Stream.of(searchResponse.getHits().getHits()).map(this.documentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        try {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
            SearchResponse response = this.searchJobs((QueryBuilder)query, pageRequest);
            return Stream.of(response.getHits().getHits()).map(this.documentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        try {
            long count = this.countJobs((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))));
            if (count > 0L) {
                List<Job> jobs = this.getJobs(state, pageRequest);
                return new Page<Job>(count, jobs, pageRequest);
            }
            return new Page<Job>(0L, new ArrayList(), pageRequest);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        try {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"updatedAt").to((Object)updatedBefore));
            DeleteByQueryRequest request = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{this.jobIndexName}).setQuery((QueryBuilder)query).setRefresh(true);
            BulkByScrollResponse response = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
            int amountDeleted = (int)response.getDeleted();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query(ElasticSearchStorageProvider.shouldMatch(states)).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"jobSignature").field("jobSignature"));
            SearchResponse response = this.client.search(new SearchRequest(new String[]{this.jobIndexName}).source(source), RequestOptions.DEFAULT);
            Terms terms = (Terms)response.getAggregations().get("jobSignature");
            return terms.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        try {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must(ElasticSearchStorageProvider.shouldMatch(states)).must((QueryBuilder)QueryBuilders.matchQuery((String)"jobSignature", (Object)JobUtils.getJobSignature(jobDetails)));
            return this.countJobs((QueryBuilder)query) > 0L;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        try {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must(ElasticSearchStorageProvider.shouldMatch(states)).must((QueryBuilder)QueryBuilders.matchQuery((String)"recurringJobId", (Object)recurringJobId));
            return this.countJobs((QueryBuilder)query) > 0L;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob job) {
        try {
            IndexRequest request = ((IndexRequest)((IndexRequest)new IndexRequest().index(this.recurringJobIndexName)).id(job.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.documentMapper.toXContentBuilder(job));
            this.client.index(request, RequestOptions.DEFAULT);
            return job;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).storedField("jobAsJson").size(10000);
            SearchResponse response = this.client.search(new SearchRequest().indices(new String[]{this.recurringJobIndexName}).source(source), RequestOptions.DEFAULT);
            List<RecurringJob> jobs = Stream.of(response.getHits().getHits()).map(this.documentMapper::toRecurringJob).collect(Collectors.toList());
            return new RecurringJobsResult((Collection<RecurringJob>)jobs);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).aggregation((AggregationBuilder)AggregationBuilders.sum((String)"createdAt").field("createdAt")).size(0);
            SearchRequest search = new SearchRequest().indices(new String[]{this.recurringJobIndexName}).source(source);
            SearchResponse response = this.client.search(search, RequestOptions.DEFAULT);
            ParsedSum parsedSum = (ParsedSum)response.getAggregations().get("createdAt");
            return !recurringJobsUpdatedHash.equals(Double.valueOf(parsedSum.getValue()).longValue());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public long countRecurringJobs() {
        try {
            return this.getCount(this.recurringJobIndexName);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteRecurringJob(String id) {
        try {
            DeleteRequest request = (DeleteRequest)((DeleteRequest)new DeleteRequest().index(this.recurringJobIndexName)).id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            DeleteResponse response = this.client.delete(request, RequestOptions.DEFAULT);
            int amountDeleted = response.getShardInfo().getSuccessful();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobStats getJobStats() {
        try {
            Instant instant = Instant.now();
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"state").field("state")).size(0);
            SearchRequest request = new SearchRequest(new String[]{this.jobIndexName}).source(source);
            SearchResponse response = this.client.search(request, RequestOptions.DEFAULT);
            Terms terms = (Terms)response.getAggregations().get("state");
            List buckets = terms.getBuckets();
            long allTimeSucceededJobs = this.getAllTimeSucceededJobs();
            int recurringJobs = this.getCount(this.recurringJobIndexName);
            int backgroundJobServers = this.getCount(this.backgroundJobServerIndexName);
            return new JobStats(instant, 0L, this.count(buckets, StateName.SCHEDULED), this.count(buckets, StateName.ENQUEUED), this.count(buckets, StateName.PROCESSING), this.count(buckets, StateName.FAILED), this.count(buckets, StateName.SUCCEEDED), allTimeSucceededJobs, this.count(buckets, StateName.DELETED), recurringJobs, backgroundJobServers);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private long getAllTimeSucceededJobs() throws IOException {
        GetRequest request = ((GetRequest)new GetRequest().index(this.metadataIndexName)).id("succeeded-jobs-counter-cluster");
        GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
        Long value = response.getSource().getOrDefault("value", 0L);
        return ((Number)value).longValue();
    }

    private int getCount(String indexName) throws IOException {
        CountRequest request = new CountRequest().indices(new String[]{indexName});
        return (int)this.client.count(request, RequestOptions.DEFAULT).getCount();
    }

    private long count(List<? extends Terms.Bucket> buckets, StateName state) {
        return buckets.stream().filter(bucket -> Objects.equals(state.name(), bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L);
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try {
            UpdateRequest update = new UpdateRequest(this.metadataIndexName, "succeeded-jobs-counter-cluster").scriptedUpsert(true);
            Map<String, Integer> parameters = Collections.singletonMap("value", amount);
            Script inline = new Script(ScriptType.INLINE, "painless", "ctx._source.value += params.value", parameters);
            update.script(inline);
            this.client.update(update, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    long countJobs(QueryBuilder query) throws IOException {
        CountRequest request = new CountRequest().indices(new String[]{this.jobIndexName}).query(query);
        CountResponse response = this.client.count(request, RequestOptions.DEFAULT);
        return response.getCount();
    }

    SearchResponse searchJobs(QueryBuilder query, PageRequest page) throws IOException {
        SearchSourceBuilder source = new SearchSourceBuilder().query(query).from((int)page.getOffset()).size(page.getLimit()).storedField("jobAsJson");
        ElasticSearchStorageProvider.sortJobs(page, source);
        SearchRequest request = new SearchRequest(new String[]{this.jobIndexName}).source(source);
        return this.client.search(request, RequestOptions.DEFAULT);
    }

    private static QueryBuilder shouldMatch(StateName ... states) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (StateName state : states) {
            query.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
        }
        return query;
    }

    private static void sortJobs(PageRequest page, SearchSourceBuilder source) {
        String order = page.getOrder();
        if (Objects.equals(order, "updatedAt:ASC")) {
            source.sort("updatedAt", SortOrder.ASC);
        } else if (Objects.equals(order, "updatedAt:DESC")) {
            source.sort("updatedAt", SortOrder.DESC);
        } else {
            throw new IllegalArgumentException("Unknown sort: " + order);
        }
    }
}

