/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M002_CreateRecurringJobsIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(RestHighLevelClient client, String indexPrefix) throws IOException {
        String recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_recurring_jobs");
        if (M002_CreateRecurringJobsIndex.indexExists(client, recurringJobIndexName)) {
            return;
        }
        M002_CreateRecurringJobsIndex.createIndex(client, M002_CreateRecurringJobsIndex.recurringJobIndex(recurringJobIndexName));
    }

    private static CreateIndexRequest recurringJobIndex(String recurringJobIndexName) {
        return new CreateIndexRequest(recurringJobIndexName).mapping(M002_CreateRecurringJobsIndex.mapping((sb, map) -> {
            sb.append("jobAsJson");
            map.put("type", "text");
            map.put("index", false);
            map.put("store", true);
        }));
    }
}

