/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.elasticsearch.migrations.ElasticSearchMigration;

public class M003_CreateBackgroundJobServersIndex
extends ElasticSearchMigration {
    @Override
    public void runMigration(RestHighLevelClient client, String indexPrefix) throws IOException {
        String backgroundJobServerIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, "jobrunr_background_job_servers");
        if (M003_CreateBackgroundJobServersIndex.indexExists(client, backgroundJobServerIndexName)) {
            return;
        }
        M003_CreateBackgroundJobServersIndex.createIndex(client, M003_CreateBackgroundJobServersIndex.backgroundJobServersIndex(backgroundJobServerIndexName));
    }

    private static CreateIndexRequest backgroundJobServersIndex(String backgroundJobServerIndexName) {
        return new CreateIndexRequest(backgroundJobServerIndexName).mapping(M003_CreateBackgroundJobServersIndex.mapping((sb, map) -> {
            sb.append("firstHeartbeat");
            map.put("type", "date_nanos");
        }, (sb, map) -> {
            sb.append("lastHeartbeat");
            map.put("type", "date_nanos");
        }));
    }
}

