/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo;

import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Binary;
import org.jobrunr.JobRunrException;

public class MongoUtils {
    private MongoUtils() {
    }

    public static UUID getIdAsUUID(Document document) {
        if (document.get((Object)"_id") instanceof UUID) {
            return (UUID)document.get((Object)"_id", UUID.class);
        }
        Binary idAsBinary = (Binary)document.get((Object)"_id", Binary.class);
        if (BsonBinarySubType.isUuid((byte)idAsBinary.getType())) {
            if (idAsBinary.getType() == BsonBinarySubType.UUID_STANDARD.getValue()) {
                return UuidHelper.decodeBinaryToUuid((byte[])MongoUtils.clone(idAsBinary.getData()), (byte)idAsBinary.getType(), (UuidRepresentation)UuidRepresentation.STANDARD);
            }
            if (idAsBinary.getType() == BsonBinarySubType.UUID_LEGACY.getValue()) {
                return UuidHelper.decodeBinaryToUuid((byte[])MongoUtils.clone(idAsBinary.getData()), (byte)idAsBinary.getType(), (UuidRepresentation)UuidRepresentation.JAVA_LEGACY);
            }
        }
        throw JobRunrException.shouldNotHappenException("Unknown id: " + document.get((Object)"_id").getClass());
    }

    public static byte[] clone(byte[] array) {
        byte[] result = new byte[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }
}

