/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.mapper;

import java.time.Duration;
import java.util.Date;
import org.bson.Document;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.nosql.mongo.MongoUtils;

public class BackgroundJobServerStatusDocumentMapper {
    public Document toInsertDocument(BackgroundJobServerStatus serverStatus) {
        Document document = new Document();
        document.put("_id", (Object)serverStatus.getId());
        document.put("name", (Object)serverStatus.getName());
        document.put("workerPoolSize", (Object)serverStatus.getWorkerPoolSize());
        document.put("pollIntervalInSeconds", (Object)serverStatus.getPollIntervalInSeconds());
        document.put("deleteSucceededJobsAfter", (Object)serverStatus.getDeleteSucceededJobsAfter().toString());
        document.put("permanentlyDeleteDeletedJobsAfter", (Object)serverStatus.getPermanentlyDeleteDeletedJobsAfter().toString());
        document.put("firstHeartbeat", (Object)serverStatus.getFirstHeartbeat());
        document.put("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
        document.put("running", (Object)serverStatus.isRunning());
        document.put("systemTotalMemory", (Object)serverStatus.getSystemTotalMemory());
        document.put("systemFreeMemory", (Object)serverStatus.getSystemFreeMemory());
        document.put("systemCpuLoad", (Object)serverStatus.getSystemCpuLoad());
        document.put("processMaxMemory", (Object)serverStatus.getProcessMaxMemory());
        document.put("processFreeMemory", (Object)serverStatus.getProcessFreeMemory());
        document.put("processAllocatedMemory", (Object)serverStatus.getProcessAllocatedMemory());
        document.put("processCpuLoad", (Object)serverStatus.getProcessCpuLoad());
        return document;
    }

    public Document toUpdateDocument(BackgroundJobServerStatus serverStatus) {
        Document document = new Document();
        document.put("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
        document.put("systemFreeMemory", (Object)serverStatus.getSystemFreeMemory());
        document.put("systemCpuLoad", (Object)serverStatus.getSystemCpuLoad());
        document.put("processFreeMemory", (Object)serverStatus.getProcessFreeMemory());
        document.put("processAllocatedMemory", (Object)serverStatus.getProcessAllocatedMemory());
        document.put("processCpuLoad", (Object)serverStatus.getProcessCpuLoad());
        return new Document("$set", (Object)document);
    }

    public BackgroundJobServerStatus toBackgroundJobServerStatus(Document document) {
        return new BackgroundJobServerStatus(MongoUtils.getIdAsUUID(document), document.getString((Object)"name"), document.getInteger((Object)"workerPoolSize"), document.getInteger((Object)"pollIntervalInSeconds"), Duration.parse(document.getString((Object)"deleteSucceededJobsAfter")), Duration.parse(document.getString((Object)"permanentlyDeleteDeletedJobsAfter")), ((Date)document.get((Object)"firstHeartbeat", Date.class)).toInstant(), ((Date)document.get((Object)"lastHeartbeat", Date.class)).toInstant(), document.getBoolean((Object)"running"), document.getLong((Object)"systemTotalMemory"), document.getLong((Object)"systemFreeMemory"), document.getDouble((Object)"systemCpuLoad"), document.getLong((Object)"processMaxMemory"), document.getLong((Object)"processFreeMemory"), document.getLong((Object)"processAllocatedMemory"), document.getDouble((Object)"processCpuLoad"));
    }
}

