/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.mapper;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;

public class JobDocumentMapper {
    private final JobMapper jobMapper;

    public JobDocumentMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    public Document toInsertDocument(Job job) {
        Document document = new Document();
        document.put(MongoDBStorageProvider.toMongoId("id"), (Object)job.getId());
        document.put("version", (Object)job.getVersion());
        document.put("jobAsJson", (Object)this.jobMapper.serializeJob(job));
        document.put("jobSignature", (Object)job.getJobSignature());
        document.put("state", (Object)job.getState().name());
        document.put("createdAt", (Object)this.toMicroSeconds(job.getCreatedAt()));
        document.put("updatedAt", (Object)this.toMicroSeconds(job.getUpdatedAt()));
        if (job.hasState(StateName.SCHEDULED)) {
            document.put("scheduledAt", (Object)this.toMicroSeconds(((ScheduledState)job.getJobState()).getScheduledAt()));
        }
        job.getRecurringJobId().ifPresent(recurringJobId -> document.put("recurringJobId", recurringJobId));
        return document;
    }

    public Document toUpdateDocument(Job job) {
        Document document = new Document();
        document.put("version", (Object)job.getVersion());
        document.put("jobAsJson", (Object)this.jobMapper.serializeJob(job));
        document.put("state", (Object)job.getState().name());
        document.put("updatedAt", (Object)this.toMicroSeconds(job.getUpdatedAt()));
        if (job.hasState(StateName.SCHEDULED)) {
            document.put("scheduledAt", (Object)this.toMicroSeconds(((ScheduledState)job.getJobState()).getScheduledAt()));
        }
        job.getRecurringJobId().ifPresent(recurringJobId -> document.put("recurringJobId", recurringJobId));
        return new Document("$set", (Object)document);
    }

    public UpdateOneModel<Document> toUpdateOneModel(Job job) {
        Document filterDocument = new Document();
        filterDocument.append(MongoDBStorageProvider.toMongoId("id"), (Object)job.getId());
        filterDocument.append("version", (Object)(job.getVersion() - 1));
        Document updateDocument = this.toUpdateDocument(job);
        UpdateOptions updateOptions = new UpdateOptions();
        updateOptions.upsert(false);
        return new UpdateOneModel((Bson)filterDocument, (Bson)updateDocument, updateOptions);
    }

    public Job toJob(Document document) {
        return this.jobMapper.deserializeJob(document.get((Object)"jobAsJson").toString());
    }

    public Document toInsertDocument(RecurringJob recurringJob) {
        Document document = new Document();
        document.put(MongoDBStorageProvider.toMongoId("id"), (Object)recurringJob.getId());
        document.put("version", (Object)recurringJob.getVersion());
        document.put("jobAsJson", (Object)this.jobMapper.serializeRecurringJob(recurringJob));
        document.put("createdAt", (Object)recurringJob.getCreatedAt().toEpochMilli());
        return document;
    }

    public Bson byId(List<UUID> ids) {
        return Filters.in((String)MongoDBStorageProvider.toMongoId("id"), ids);
    }

    public RecurringJob toRecurringJob(Document document) {
        return this.jobMapper.deserializeRecurringJob(document.get((Object)"jobAsJson").toString());
    }

    private long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }
}

