/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.mapper;

import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bson.conversions.Bson;
import org.jobrunr.storage.PageRequest;

public class MongoDBPageRequestMapper {
    private static final Set<String> allowedSortColumns = new HashSet<String>();

    public Bson map(PageRequest pageRequest) {
        String[] sortOns;
        ArrayList<Bson> result = new ArrayList<Bson>();
        for (String sortOn : sortOns = pageRequest.getOrder().split(",")) {
            String[] sortAndOrder = sortOn.split(":");
            if (!allowedSortColumns.contains(sortAndOrder[0])) continue;
            String sortField = sortAndOrder[0];
            PageRequest.Order order = PageRequest.Order.ASC;
            if (sortAndOrder.length > 1) {
                order = PageRequest.Order.valueOf(sortAndOrder[1].toUpperCase());
            }
            result.add(order == PageRequest.Order.ASC ? Sorts.ascending((String[])new String[]{sortField}) : Sorts.descending((String[])new String[]{sortField}));
        }
        return Sorts.orderBy(result);
    }

    static {
        allowedSortColumns.add("createdAt");
        allowedSortColumns.add("updatedAt");
    }
}

