/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.mongo.migrations.MongoMigration;

public class M001_CreateJobCollection
extends MongoMigration {
    @Override
    public void runMigration(MongoDatabase jobrunrDatabase, String collectionPrefix) {
        String collectionName = StorageProviderUtils.elementPrefixer(collectionPrefix, "jobs");
        if (this.collectionExists(jobrunrDatabase, collectionName)) {
            return;
        }
        if (this.createCollection(jobrunrDatabase, collectionName)) {
            MongoCollection jobCollection = jobrunrDatabase.getCollection(collectionName, Document.class);
            jobCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"scheduledAt"})}));
            jobCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"updatedAt"})}));
            jobCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.descending((String[])new String[]{"updatedAt"})}));
            jobCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"createdAt"})}));
            jobCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"jobSignature"})}));
        }
    }
}

