/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo.migrations;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.mongo.migrations.MongoMigration;

public class M007_UpdateJobsCollectionReplaceIndices
extends MongoMigration {
    @Override
    public void runMigration(MongoDatabase jobrunrDatabase, String collectionPrefix) {
        String collectionName = StorageProviderUtils.elementPrefixer(collectionPrefix, "jobs");
        MongoCollection jobCollection = jobrunrDatabase.getCollection(collectionName, Document.class);
        this.dropIndexes((MongoCollection<Document>)jobCollection);
        this.createIndex((MongoCollection<Document>)jobCollection, Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"recurringJobId"})}), new IndexOptions().name("recurringJobPartialIdx").partialFilterExpression(Filters.exists((String)"recurringJobId")));
        this.createIndex((MongoCollection<Document>)jobCollection, Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"scheduledAt"})}), new IndexOptions().name("scheduledPartialIdx").partialFilterExpression(Filters.eq((String)"state", (Object)StateName.SCHEDULED.name())));
        this.createIndex((MongoCollection<Document>)jobCollection, Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"updatedAt"})}), new IndexOptions().name("jobsByStateUpdatedAtAscIdx"));
        this.createIndex((MongoCollection<Document>)jobCollection, Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.descending((String[])new String[]{"updatedAt"})}), new IndexOptions().name("jobsByStateUpdatedAtDescIdx"));
    }
}

