/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.storage.nosql.redis.AbstractPipelinedStream;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class JedisRedisPipelinedStream<T>
extends AbstractPipelinedStream<T> {
    private final Jedis jedis;

    public JedisRedisPipelinedStream(Collection<T> initial, Jedis jedis) {
        this(initial.stream(), jedis);
    }

    public JedisRedisPipelinedStream(Stream<T> initialStream, Jedis jedis) {
        super(initialStream);
        this.jedis = jedis;
    }

    public <R> JedisRedisPipelinedStream<R> mapUsingPipeline(BiFunction<Pipeline, T, R> biFunction) {
        List collect;
        try (Pipeline pipeline = this.jedis.pipelined();){
            collect = this.initialStream.map(item -> biFunction.apply(pipeline, item)).collect(Collectors.toList());
            pipeline.sync();
        }
        return new JedisRedisPipelinedStream(collect, this.jedis);
    }

    public <R> JedisRedisPipelinedStream<R> mapAfterSync(Function<? super T, ? extends R> function) {
        return new JedisRedisPipelinedStream<R>(this.initialStream.map(function), this.jedis);
    }

    @Override
    public JedisRedisPipelinedStream<T> limit(long l) {
        return new JedisRedisPipelinedStream(this.initialStream.limit(l), this.jedis);
    }

    @Override
    public JedisRedisPipelinedStream<T> skip(long l) {
        return new JedisRedisPipelinedStream(this.initialStream.skip(l), this.jedis);
    }
}

