/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.storage.nosql.redis.AbstractPipelinedStream;
import org.jobrunr.utils.exceptions.Exceptions;

public class LettuceRedisPipelinedStream<T>
extends AbstractPipelinedStream<T> {
    private final StatefulRedisConnection<String, String> connection;

    public LettuceRedisPipelinedStream(Collection<T> initial, StatefulRedisConnection<String, String> connection) {
        this(initial.stream(), connection);
    }

    public LettuceRedisPipelinedStream(Stream<T> initialStream, StatefulRedisConnection<String, String> connection) {
        super(initialStream);
        this.connection = connection;
    }

    public <R> LettuceRedisPipelinedStream<R> mapUsingPipeline(BiFunction<RedisAsyncCommands<String, String>, T, R> biFunction) {
        this.connection.setAutoFlushCommands(false);
        RedisAsyncCommands redisAsyncCommands = this.connection.async();
        List<RedisFuture> collect = this.initialStream.map(item -> biFunction.apply(redisAsyncCommands, item)).collect(Collectors.toList());
        this.connection.flushCommands();
        LettuceFutures.awaitAll((Duration)Duration.ofSeconds(10L), (Future[])((Future[])collect.toArray(new RedisFuture[0])));
        return new LettuceRedisPipelinedStream(collect, this.connection);
    }

    public <R> LettuceRedisPipelinedStream<R> mapAfterSync(Exceptions.ThrowingFunction<? super T, ? extends R> function) {
        Stream<Object> rStream = this.initialStream.map(x -> {
            try {
                return function.apply(x);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        return new LettuceRedisPipelinedStream<Object>(rStream, this.connection);
    }

    @Override
    public LettuceRedisPipelinedStream<T> limit(long l) {
        return new LettuceRedisPipelinedStream(this.initialStream.limit(l), this.connection);
    }

    @Override
    public LettuceRedisPipelinedStream<T> skip(long l) {
        return new LettuceRedisPipelinedStream(this.initialStream.skip(l), this.connection);
    }
}

