/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.sql.common.db.ConcurrentSqlModificationException;
import org.jobrunr.storage.sql.common.db.Sql;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;

public class BackgroundJobServerTable
extends Sql<BackgroundJobServerStatus> {
    public BackgroundJobServerTable(Connection connection, Dialect dialect, String tablePrefix) {
        this.using(connection, dialect, tablePrefix, "jobrunr_backgroundjobservers").with("id", BackgroundJobServerStatus::getId).with("name", BackgroundJobServerStatus::getName).with("workerPoolSize", BackgroundJobServerStatus::getWorkerPoolSize).with("pollIntervalInSeconds", BackgroundJobServerStatus::getPollIntervalInSeconds).with("deleteSucceededJobsAfter", BackgroundJobServerStatus::getDeleteSucceededJobsAfter).with("permanentlyDeleteJobsAfter", BackgroundJobServerStatus::getPermanentlyDeleteDeletedJobsAfter).with("firstHeartbeat", BackgroundJobServerStatus::getFirstHeartbeat).with("lastHeartbeat", BackgroundJobServerStatus::getLastHeartbeat).with("running", BackgroundJobServerStatus::isRunning).with("systemTotalMemory", BackgroundJobServerStatus::getSystemTotalMemory).with("systemFreeMemory", BackgroundJobServerStatus::getSystemFreeMemory).with("systemCpuLoad", BackgroundJobServerStatus::getSystemCpuLoad).with("processMaxMemory", BackgroundJobServerStatus::getProcessMaxMemory).with("processFreeMemory", BackgroundJobServerStatus::getProcessFreeMemory).with("processAllocatedMemory", BackgroundJobServerStatus::getProcessAllocatedMemory).with("processCpuLoad", BackgroundJobServerStatus::getProcessCpuLoad);
    }

    public void announce(BackgroundJobServerStatus serverStatus) throws SQLException {
        this.with("id", serverStatus.getId()).delete("from jobrunr_backgroundjobservers where id = :id");
        this.insert(serverStatus, "into jobrunr_backgroundjobservers(id, name, workerPoolSize, pollIntervalInSeconds, firstHeartbeat, lastHeartbeat, running, systemTotalMemory, systemFreeMemory, systemCpuLoad, processMaxMemory, processFreeMemory, processAllocatedMemory, processCpuLoad, deleteSucceededJobsAfter, permanentlyDeleteJobsAfter) values (:id, :name, :workerPoolSize, :pollIntervalInSeconds, :firstHeartbeat, :lastHeartbeat, :running, :systemTotalMemory, :systemFreeMemory, :systemCpuLoad, :processMaxMemory, :processFreeMemory, :processAllocatedMemory, :processCpuLoad, :deleteSucceededJobsAfter, :permanentlyDeleteJobsAfter)");
    }

    public boolean signalServerAlive(BackgroundJobServerStatus serverStatus) throws SQLException {
        try {
            this.with("id", serverStatus.getId()).with("lastHeartbeat", serverStatus.getLastHeartbeat()).with("systemFreeMemory", serverStatus.getSystemFreeMemory()).with("systemCpuLoad", serverStatus.getSystemCpuLoad()).with("processFreeMemory", serverStatus.getProcessFreeMemory()).with("processAllocatedMemory", serverStatus.getProcessAllocatedMemory()).with("processCpuLoad", serverStatus.getSystemCpuLoad()).update("jobrunr_backgroundjobservers SET lastHeartbeat = :lastHeartbeat, systemFreeMemory = :systemFreeMemory, systemCpuLoad = :systemCpuLoad, processFreeMemory = :processFreeMemory, processAllocatedMemory = :processAllocatedMemory, processCpuLoad = :processCpuLoad where id = :id");
        }
        catch (ConcurrentSqlModificationException e) {
            throw new ServerTimedOutException(serverStatus, new StorageException("Background Job Server with id " + serverStatus.getId() + " is not found"));
        }
        return this.select("running from jobrunr_backgroundjobservers where id = :id").map(sqlResultSet -> sqlResultSet.asBoolean("running")).findFirst().orElseThrow(() -> new ServerTimedOutException(serverStatus, new StorageException("Background Job Server with id " + serverStatus.getId() + " is not found")));
    }

    public void signalServerStopped(BackgroundJobServerStatus serverStatus) {
        try {
            this.with("id", serverStatus.getId()).delete("from jobrunr_backgroundjobservers where id = :id");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int removeAllWithLastHeartbeatOlderThan(Instant heartbeatOlderThan) throws SQLException {
        return this.with("heartbeatOlderThan", heartbeatOlderThan).delete("from jobrunr_backgroundjobservers where lastHeartbeat < :heartbeatOlderThan");
    }

    public List<BackgroundJobServerStatus> getAll() {
        return this.select("* from jobrunr_backgroundjobservers order by firstHeartbeat").map(this::toBackgroundJobServerStatus).collect(Collectors.toList());
    }

    public UUID getLongestRunningBackgroundJobServerId() {
        return this.withOrderLimitAndOffset("firstHeartbeat ASC", 1, 0L).select("id from jobrunr_backgroundjobservers").map(sqlResultSet -> sqlResultSet.asUUID("id")).findFirst().orElseThrow(() -> JobRunrException.shouldNotHappenException("No servers available?!"));
    }

    private BackgroundJobServerStatus toBackgroundJobServerStatus(SqlResultSet resultSet) {
        return new BackgroundJobServerStatus(resultSet.asUUID("id"), resultSet.asString("name"), resultSet.asInt("workerPoolSize"), resultSet.asInt("pollIntervalInSeconds"), resultSet.asDuration("deleteSucceededJobsAfter"), resultSet.asDuration("permanentlyDeleteJobsAfter"), resultSet.asInstant("firstHeartbeat"), resultSet.asInstant("lastHeartbeat"), resultSet.asBoolean("running"), resultSet.asLong("systemTotalMemory"), resultSet.asLong("systemFreeMemory"), resultSet.asDouble("systemCpuLoad"), resultSet.asLong("processMaxMemory"), resultSet.asLong("processFreeMemory"), resultSet.asLong("processAllocatedMemory"), resultSet.asDouble("processCpuLoad"));
    }
}

