/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.RecurringJobsResult;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.SqlStorageProvider;
import org.jobrunr.storage.sql.common.BackgroundJobServerTable;
import org.jobrunr.storage.sql.common.DatabaseCreator;
import org.jobrunr.storage.sql.common.JobStatsView;
import org.jobrunr.storage.sql.common.JobTable;
import org.jobrunr.storage.sql.common.MetadataTable;
import org.jobrunr.storage.sql.common.RecurringJobTable;
import org.jobrunr.storage.sql.common.db.Transaction;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;
import org.jobrunr.utils.resilience.RateLimiter;

public class DefaultSqlStorageProvider
extends AbstractStorageProvider
implements SqlStorageProvider {
    protected final DataSource dataSource;
    protected final Dialect dialect;
    protected final String tablePrefix;
    private JobMapper jobMapper;

    public DefaultSqlStorageProvider(DataSource dataSource, Dialect dialect, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(dataSource, dialect, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public DefaultSqlStorageProvider(DataSource dataSource, Dialect dialect, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(dataSource, dialect, tablePrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public DefaultSqlStorageProvider(DataSource dataSource, Dialect dialect, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        this(dataSource, dialect, null, databaseOptions, changeListenerNotificationRateLimit);
    }

    DefaultSqlStorageProvider(DataSource dataSource, Dialect dialect, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.tablePrefix = tablePrefix;
        this.setUpStorageProvider(databaseOptions);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (databaseOptions == StorageProviderUtils.DatabaseOptions.CREATE) {
            this.getDatabaseCreator().runMigrations();
        } else {
            this.getDatabaseCreator().validateTables();
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        try (Connection conn = this.dataSource.getConnection();
             Transaction transaction = new Transaction(conn);){
            this.backgroundJobServerTable(conn).announce(serverStatus);
            transaction.commit();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            try (Transaction transaction = new Transaction(conn);){
                boolean isServerAlive = this.backgroundJobServerTable(conn).signalServerAlive(serverStatus);
                transaction.commit();
                bl = isServerAlive;
            }
            return bl;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        try (Connection conn = this.dataSource.getConnection();
             Transaction transaction = new Transaction(conn);){
            this.backgroundJobServerTable(conn).signalServerStopped(serverStatus);
            transaction.commit();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        List<BackgroundJobServerStatus> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.backgroundJobServerTable(conn).getAll();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        UUID uUID;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                uUID = this.backgroundJobServerTable(conn).getLongestRunningBackgroundJobServerId();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return uUID;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        try (Connection conn = this.dataSource.getConnection();){
            int n;
            try (Transaction transaction = new Transaction(conn);){
                int deletedBackgroundJobServers = this.backgroundJobServerTable(conn).removeAllWithLastHeartbeatOlderThan(heartbeatOlderThan);
                transaction.commit();
                n = deletedBackgroundJobServers;
            }
            return n;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try (Connection conn = this.dataSource.getConnection();
             Transaction transaction = new Transaction(conn);){
            this.metadataTable(conn).save(metadata);
            transaction.commit();
            this.notifyMetadataChangeListeners();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        List<JobRunrMetadata> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.metadataTable(conn).getAll(name);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        JobRunrMetadata jobRunrMetadata;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                jobRunrMetadata = this.metadataTable(conn).get(name, owner);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return jobRunrMetadata;
    }

    @Override
    public void deleteMetadata(String name) {
        try (Connection conn = this.dataSource.getConnection();
             Transaction transaction = new Transaction(conn);){
            int amountDeleted = this.metadataTable(conn).deleteByName(name);
            transaction.commit();
            this.notifyMetadataChangeListeners(amountDeleted > 0);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Job save(Job jobToSave) {
        try (Connection conn = this.dataSource.getConnection();){
            Job job;
            try (Transaction transaction = new Transaction(conn);){
                Job savedJob = this.jobTable(conn).save(jobToSave);
                transaction.commit();
                this.notifyJobStatsOnChangeListeners();
                job = savedJob;
            }
            return job;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Job> save(List<Job> jobs) {
        try (Connection conn = this.dataSource.getConnection();){
            List<Job> list;
            try (Transaction transaction = new Transaction(conn);){
                List<Job> savedJobs = this.jobTable(conn).save(jobs);
                transaction.commit();
                this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
                list = savedJobs;
            }
            return list;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job getJobById(UUID id) {
        Job job;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                job = this.jobTable(conn).selectJobById(id).orElseThrow(() -> new JobNotFoundException(id));
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return job;
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        List<Job> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.jobTable(conn).selectJobsScheduledBefore(scheduledBefore, pageRequest);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        List<Job> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.jobTable(conn).selectJobsByState(state, pageRequest);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        List<Job> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.jobTable(conn).selectJobsByState(state, updatedBefore, pageRequest);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        try (Connection conn = this.dataSource.getConnection();){
            long count = this.jobTable(conn).countJobs(state);
            if (count > 0L && pageRequest.getLimit() > 0) {
                List<Job> jobs = this.jobTable(conn).selectJobsByState(state, pageRequest);
                Page<Job> page2 = new Page<Job>(count, jobs, pageRequest);
                return page2;
            }
            Page<Job> page = new Page<Job>(count, new ArrayList(), pageRequest);
            return page;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deletePermanently(UUID id) {
        try (Connection conn = this.dataSource.getConnection();){
            int n;
            try (Transaction transaction = new Transaction(conn);){
                int amountDeleted = this.jobTable(conn).deletePermanently(id);
                transaction.commit();
                this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
                n = amountDeleted;
            }
            return n;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        try (Connection conn = this.dataSource.getConnection();){
            int n;
            try (Transaction transaction = new Transaction(conn);){
                int amountDeleted = this.jobTable(conn).deleteJobsByStateAndUpdatedBefore(state, updatedBefore);
                transaction.commit();
                this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
                n = amountDeleted;
            }
            return n;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        Set<String> set;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                set = this.jobTable(conn).getDistinctJobSignatures(states);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return set;
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        boolean bl;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                bl = this.jobTable(conn).exists(jobDetails, states);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        boolean bl;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                bl = this.jobTable(conn).recurringJobExists(recurringJobId, states);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        try (Connection conn = this.dataSource.getConnection();){
            RecurringJob recurringJob2;
            try (Transaction transaction = new Transaction(conn);){
                RecurringJob savedRecurringJob = this.recurringJobTable(conn).save(recurringJob);
                transaction.commit();
                recurringJob2 = savedRecurringJob;
            }
            return recurringJob2;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJobsResult getRecurringJobs() {
        RecurringJobsResult recurringJobsResult;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                recurringJobsResult = new RecurringJobsResult((Collection<RecurringJob>)this.recurringJobTable(conn).selectAll());
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return recurringJobsResult;
    }

    @Override
    public boolean recurringJobsUpdated(Long recurringJobsUpdatedHash) {
        boolean bl;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                Long lastModifiedHash = this.recurringJobTable(conn).selectSum("createdAt");
                boolean bl2 = bl = !recurringJobsUpdatedHash.equals(lastModifiedHash);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return bl;
    }

    @Override
    public long countRecurringJobs() {
        long l;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                l = this.recurringJobTable(conn).count();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return l;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteRecurringJob(String id) {
        try (Connection conn = this.dataSource.getConnection();){
            int n;
            try (Transaction transaction = new Transaction(conn);){
                int deletedRecurringJobCount = this.recurringJobTable(conn).deleteById(id);
                transaction.commit();
                n = deletedRecurringJobCount;
            }
            return n;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobStats getJobStats() {
        JobStats jobStats;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                jobStats = this.jobStatsView(conn).getJobStats();
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            conn.close();
        }
        return jobStats;
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try (Connection conn = this.dataSource.getConnection();
             Transaction transaction = new Transaction(conn);){
            this.metadataTable(conn).incrementCounter("succeeded-jobs-counter-cluster", amount);
            transaction.commit();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected DatabaseCreator getDatabaseCreator() {
        return new DatabaseCreator(this.dataSource, this.tablePrefix, this.getClass());
    }

    protected JobTable jobTable(Connection connection) {
        return new JobTable(connection, this.dialect, this.tablePrefix, this.jobMapper);
    }

    protected RecurringJobTable recurringJobTable(Connection connection) {
        return new RecurringJobTable(connection, this.dialect, this.tablePrefix, this.jobMapper);
    }

    protected BackgroundJobServerTable backgroundJobServerTable(Connection connection) {
        return new BackgroundJobServerTable(connection, this.dialect, this.tablePrefix);
    }

    protected MetadataTable metadataTable(Connection connection) {
        return new MetadataTable(connection, this.dialect, this.tablePrefix);
    }

    protected JobStatsView jobStatsView(Connection connection) {
        return new JobStatsView(connection, this.dialect, this.tablePrefix);
    }
}

