/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.db.ConcurrentSqlModificationException;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.jobrunr.storage.sql.common.db.SqlSpliterator;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;
import org.jobrunr.utils.annotations.VisibleFor;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class Sql<T> {
    private static final String INSERT = "insert ";
    private static final String UPDATE = "update ";
    private static final String DELETE = "delete ";
    private final List<String> paramNames = new ArrayList<String>();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final Map<String, Function<T, ?>> paramSuppliers = new HashMap();
    private Dialect dialect;
    private String tablePrefix;
    private String suffix = "";
    private static final Map<Integer, ParsedStatement> parsedStatementCache = new ConcurrentHashMap<Integer, ParsedStatement>();
    private String tableName;
    private Connection connection;

    protected Sql() {
    }

    public static <T> Sql<T> forType(Class<T> tClass) {
        return new Sql<T>();
    }

    public Sql<T> using(Connection connection, Dialect dialect, String tablePrefix, String tableName) {
        this.connection = connection;
        this.dialect = dialect;
        this.tablePrefix = tablePrefix;
        this.tableName = tableName;
        return this;
    }

    public Sql<T> with(String name, Enum<?> value) {
        this.params.put(name, value.name());
        return this;
    }

    public Sql<T> with(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public Sql<T> with(String name, Function<T, Object> function) {
        this.paramSuppliers.put(name, function);
        return this;
    }

    public Sql<T> withVersion(Function<T, Integer> function) {
        this.paramSuppliers.put("version", function);
        return this;
    }

    public Sql<T> withOrderLimitAndOffset(String order, int limit, long offset) {
        this.with("limit", limit);
        this.with("offset", offset);
        this.suffix = this.dialect.limitAndOffset(order);
        return this;
    }

    public Stream<SqlResultSet> select(String statement) {
        String parsedStatement = this.parse("select " + statement + this.suffix);
        SqlSpliterator sqlSpliterator = new SqlSpliterator(this.connection, parsedStatement, this::setParams);
        return StreamSupport.stream(sqlSpliterator, false);
    }

    public Stream<SqlResultSet> execute(String statement) {
        String parsedStatement = this.parse(statement + this.suffix);
        SqlSpliterator sqlSpliterator = new SqlSpliterator(this.connection, parsedStatement, this::setParams);
        return StreamSupport.stream(sqlSpliterator, false);
    }

    public long selectCount(String statement) throws SQLException {
        String parsedStatement = this.parse("select count(*) " + statement);
        try (PreparedStatement ps = this.connection.prepareStatement(parsedStatement);){
            long l;
            block12: {
                this.setParams(ps);
                ResultSet countResultSet = ps.executeQuery();
                try {
                    countResultSet.next();
                    l = countResultSet.getLong(1);
                    if (countResultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (countResultSet != null) {
                        try {
                            countResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                countResultSet.close();
            }
            return l;
        }
    }

    public long selectSum(String column) throws SQLException {
        String parsedStatement = this.parse("select sum(" + column + ") from " + this.tableName);
        try (PreparedStatement ps = this.connection.prepareStatement(parsedStatement);){
            long l;
            block12: {
                this.setParams(ps);
                ResultSet countResultSet = ps.executeQuery();
                try {
                    countResultSet.next();
                    l = countResultSet.getLong(1);
                    if (countResultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (countResultSet != null) {
                        try {
                            countResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                countResultSet.close();
            }
            return l;
        }
    }

    public boolean selectExists(String statement) throws SQLException {
        return this.selectCount(statement) > 0L;
    }

    public void insert(T item, String statement) throws SQLException {
        this.insertOrUpdate(item, INSERT + statement);
    }

    public void insert(String statement) throws SQLException {
        this.insertOrUpdate(null, INSERT + statement);
    }

    public void update(String statement) throws SQLException {
        this.insertOrUpdate(null, UPDATE + statement);
    }

    public void update(T item, String statement) throws SQLException {
        this.insertOrUpdate(item, UPDATE + statement);
    }

    public int delete(String statement) throws SQLException {
        String parsedStatement = this.parse(DELETE + statement);
        try (PreparedStatement ps = this.connection.prepareStatement(parsedStatement);){
            this.setParams(ps);
            int n = ps.executeUpdate();
            return n;
        }
    }

    private void insertOrUpdate(T item, String statement) throws SQLException {
        String parsedStatement = this.parse(statement);
        try (PreparedStatement ps = this.connection.prepareStatement(parsedStatement);){
            this.setParams(ps, item);
            int updated = ps.executeUpdate();
            if (updated != 1) {
                throw ConcurrentSqlModificationException.concurrentDatabaseModificationException(item, updated);
            }
        }
        catch (SQLException e) {
            String lowerCaseMessage = e.getMessage().toLowerCase();
            if (e.getErrorCode() == -803 || lowerCaseMessage.contains("duplicate") || lowerCaseMessage.contains("primary key") || lowerCaseMessage.contains("unique constraint")) {
                throw ConcurrentSqlModificationException.concurrentDatabaseModificationException(item, 0);
            }
            throw e;
        }
    }

    public void insertAll(List<T> batchCollection, String statement) throws SQLException {
        int[] result = this.insertOrUpdateAll(batchCollection, INSERT + statement);
        if (result.length != batchCollection.size()) {
            throw JobRunrException.shouldNotHappenException("Could not insert or update all objects - different result size: originalCollectionSize=" + batchCollection.size() + "; " + Arrays.toString(result));
        }
        if (Arrays.stream(result).anyMatch(i -> i < 1 && i != -2)) {
            throw ConcurrentSqlModificationException.concurrentDatabaseModificationException(batchCollection, result);
        }
    }

    public void updateAll(List<T> batchCollection, String statement) throws SQLException {
        int[] result = this.insertOrUpdateAll(batchCollection, UPDATE + statement);
        if (result.length != batchCollection.size()) {
            throw JobRunrException.shouldNotHappenException("Could not insert or update all objects - different result size: originalCollectionSize=" + batchCollection.size() + "; " + Arrays.toString(result));
        }
        if (Arrays.stream(result).anyMatch(i -> i < 1 && i != -2)) {
            throw ConcurrentSqlModificationException.concurrentDatabaseModificationException(batchCollection, result);
        }
    }

    private int[] insertOrUpdateAll(List<T> batchCollection, String statement) throws SQLException {
        String parsedStatement = this.parse(statement);
        try (PreparedStatement ps = this.connection.prepareStatement(parsedStatement);){
            for (T object : batchCollection) {
                this.setParams(ps, object);
                ps.addBatch();
            }
            Object object = ps.executeBatch();
            return object;
        }
    }

    private void setParams(PreparedStatement ps) {
        try {
            this.setParams(ps, null);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setParams(PreparedStatement ps, T object) throws SQLException {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = this.paramNames.get(i);
            if (this.params.containsKey(paramName)) {
                this.setParam(ps, i + 1, this.params.get(paramName));
                continue;
            }
            if (this.paramSuppliers.containsKey(paramName)) {
                this.setParam(ps, i + 1, this.paramSuppliers.get(paramName).apply(object));
                continue;
            }
            if (ReflectionUtils.objectContainsFieldOrProperty(object, paramName)) {
                this.setParam(ps, i + 1, ReflectionUtils.getValueFromFieldOrProperty(object, paramName));
                continue;
            }
            if ("previousVersion".equals(paramName)) {
                this.setParam(ps, i + 1, (Integer)this.paramSuppliers.get("version").apply(object) - 1);
                continue;
            }
            throw new IllegalArgumentException(String.format("Parameter %s is not known.", paramName));
        }
    }

    private void setParam(PreparedStatement ps, int i, Object o) throws SQLException {
        if (o instanceof Integer) {
            ps.setInt(i, (Integer)o);
        } else if (o instanceof Long) {
            ps.setLong(i, (Long)o);
        } else if (o instanceof Double) {
            ps.setDouble(i, (Double)o);
        } else if (o instanceof Boolean) {
            ps.setInt(i, (Boolean)o != false ? 1 : 0);
        } else if (o instanceof Instant) {
            ps.setTimestamp(i, Timestamp.from((Instant)o), Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
        } else if (o instanceof Duration) {
            ps.setString(i, o.toString());
        } else if (o instanceof Enum) {
            ps.setString(i, ((Enum)o).name());
        } else if (o instanceof UUID || o instanceof String) {
            ps.setString(i, o.toString());
        } else if (o == null) {
            ps.setTimestamp(i, null);
        } else {
            throw new IllegalStateException(String.format("Found a value which could not be set in the preparedstatement: %s: %s", o.getClass(), o));
        }
    }

    final String parse(String query) {
        ParsedStatement parsedStatement = parsedStatementCache.computeIfAbsent(StorageProviderUtils.elementPrefixer(this.tablePrefix, query).hashCode(), hash -> this.createParsedStatement(query));
        this.paramNames.clear();
        this.paramNames.addAll(parsedStatement.paramNames);
        return parsedStatement.sqlStatement;
    }

    final ParsedStatement createParsedStatement(String query) {
        String parsedStatement = this.parseStatement(this.dialect.escape(query));
        return new ParsedStatement(parsedStatement, new ArrayList<String>(this.paramNames));
    }

    @VisibleFor(value="testing")
    String parseStatement(String query) {
        this.paramNames.clear();
        int length = query.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = 0; i < length; ++i) {
            int c = query.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1)) && !parsedQuery.toString().endsWith(":")) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                this.paramNames.add(name);
            }
            parsedQuery.append((char)c);
        }
        return parsedQuery.toString().replace(this.tableName, StorageProviderUtils.elementPrefixer(this.tablePrefix, this.tableName));
    }

    private static class ParsedStatement {
        private final String sqlStatement;
        private final List<String> paramNames;

        public ParsedStatement(String sqlStatement, List<String> paramNames) {
            this.sqlStatement = sqlStatement;
            this.paramNames = paramNames;
        }
    }
}

