/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.jobrunr.storage.StorageException;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class SqlResultSet {
    private final List<String> columns;
    private final ResultSet rs;

    public SqlResultSet(List<String> columns, ResultSet rs) {
        this.columns = columns;
        this.rs = rs;
    }

    public boolean asBoolean(String name) {
        return ReflectionUtils.autobox(this.val(name), Boolean.class);
    }

    public String asString(String name) {
        return ReflectionUtils.autobox(this.val(name), String.class);
    }

    public int asInt(String name) {
        return ReflectionUtils.autobox(this.val(name), Integer.class);
    }

    public UUID asUUID(String name) {
        return ReflectionUtils.autobox(this.val(name), UUID.class);
    }

    public long asLong(String name) {
        return ReflectionUtils.autobox(this.val(name), Long.class);
    }

    public Instant asInstant(String name) {
        return ReflectionUtils.autobox(this.valAsUTCTimestamp(name), Instant.class);
    }

    public Duration asDuration(String name) {
        return ReflectionUtils.autobox(this.val(name), Duration.class);
    }

    public double asDouble(String name) {
        return ReflectionUtils.autobox(this.val(name), Double.class);
    }

    private Object val(String name) {
        try {
            return this.rs.getObject(this.columns.indexOf(name.toLowerCase()));
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    private Timestamp valAsUTCTimestamp(String name) {
        try {
            return this.rs.getTimestamp(this.columns.indexOf(name.toLowerCase()), Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }
}

