/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.migrations;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jobrunr.storage.sql.common.migrations.SqlMigration;
import org.jobrunr.storage.sql.common.migrations.SqlMigrationByZipEntry;
import org.jobrunr.storage.sql.common.migrations.SqlMigrationProvider;

public class RunningOnJava11OrLowerWithinFatJarSqlMigrationProvider
implements SqlMigrationProvider {
    @Override
    public List<SqlMigration> getMigrations(Class<?> clazz) {
        List<SqlMigration> list;
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        URLConnection urlConnection = location.openConnection();
        ZipInputStream zipInputStream = new ZipInputStream(urlConnection.getInputStream());
        try {
            list = this.getMigrationsFromZipInputStream(zipInputStream, clazz);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Unable to find migrations.");
            }
        }
        zipInputStream.close();
        return list;
    }

    private List<SqlMigration> getMigrationsFromZipInputStream(ZipInputStream zipInputStream, Class<?> clazz) throws IOException {
        ArrayList<SqlMigration> result = new ArrayList<SqlMigration>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (this.isSqlMigration(clazz, zipEntry)) {
                result.add(this.getSqlMigrationFromZipEntry(zipInputStream, zipEntry));
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return result;
    }

    private SqlMigrationByZipEntry getSqlMigrationFromZipEntry(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int len;
        StringBuilder s = new StringBuilder();
        byte[] buffer = new byte[2048];
        while ((len = zipInputStream.read(buffer, 0, 1024)) >= 0) {
            s.append(new String(buffer, 0, len));
        }
        return new SqlMigrationByZipEntry(zipEntry.getName(), s.toString());
    }

    private boolean isSqlMigration(Class<?> clazz, ZipEntry zipEntry) {
        return zipEntry.getName().startsWith(clazz.getPackage().getName().replace(".", "/") + "/migrations") && zipEntry.getName().endsWith(".sql");
    }
}

